/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.TocFactory;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WebProjectTocPage
extends PropertyPage {
    Button addButton;
    Button editButton;
    Button removeButton;
    TableViewer viewer;
    WebProject webProject;
    SelectionListener buttonHandler = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(WebProjectTocPage.this.addButton)) {
                WebProjectTocPage.this.addTocResources(false);
            } else if (e.widget.equals(WebProjectTocPage.this.editButton)) {
                WebProjectTocPage.this.addTocResources(true);
            } else if (e.widget.equals(WebProjectTocPage.this.removeButton)) {
                WebProjectTocPage.this.removeTocResources();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite parent) {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject proj = (IProject)iAdaptable.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.narucy.webpub.core.WebProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.webProject = (WebProject)proj.getAdapter((Class)clazz2);
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        Label labe = new Label(base, 0);
        labe.setText("Toc files:");
        new Label(base, 0);
        this.viewer = new TableViewer(base);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();

            public String getText(Object file) {
                if (file instanceof IFile) {
                    return ((IFile)file).getProjectRelativePath().toString();
                }
                return this.workbenchProvider.getText(file);
            }

            public Image getImage(Object file) {
                return this.workbenchProvider.getImage(file);
            }

            public void dispose() {
                this.workbenchProvider.dispose();
            }
        });
        this.viewer.setInput((Object)this.toFileList(this.webProject.getArray("toc_pathes")));
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.addButton = this.createButton(base, "&Add");
        this.editButton = this.createButton(base, "&Edit");
        this.removeButton = this.createButton(base, "&Remove");
        return base;
    }

    Object[] resourceInput() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)this.webProject.getProject(), "Toc files"){

            protected boolean select(IResource resource) {
                return TocFactory.isTocResources((IResource)resource);
            }
        };
        dialog.setInitialElementSelections((List)this.viewer.getInput());
        return dialog.open() == 0 ? dialog.getResult() : null;
    }

    void addTocResources(boolean clearList) {
        final Object[] inputItems = this.resourceInput();
        if (inputItems != null) {
            final List tocFiles = (List)this.viewer.getInput();
            if (clearList) {
                tocFiles.clear();
            }
            IRunnableWithProgress progress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Checking toc resources", inputItems.length + 1);
                        int i = 0;
                        while (i < inputItems.length) {
                            IResource f = (IResource)inputItems[i];
                            if (!tocFiles.contains(f)) {
                                if (TocFactory.isTocResources((IResource)f)) {
                                    tocFiles.add(f);
                                }
                                monitor.worked(1);
                            }
                            ++i;
                        }
                        WebProjectTocPage.this.viewer.refresh();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var4_6 = null;
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, true, progress);
            }
            catch (InvocationTargetException e) {
                WebpubUIPlugin.handleException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void removeTocResources() {
        List tocFiles = (List)this.viewer.getInput();
        Object[] items = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        int i = 0;
        while (i < items.length) {
            tocFiles.remove(items[i]);
            ++i;
        }
        this.viewer.refresh();
    }

    Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(258));
        button.setText(text);
        button.addSelectionListener(this.buttonHandler);
        return button;
    }

    List toFileList(String[] vals) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        int i = 0;
        while (i < vals.length) {
            list.add(this.webProject.getProject().getFile(vals[i]));
            ++i;
        }
        return list;
    }

    protected void performDefaults() {
        List tocFiles = (List)this.viewer.getInput();
        tocFiles.clear();
        tocFiles.addAll(Arrays.asList(this.webProject.getDefaultArray("toc_pathes")));
        this.viewer.refresh();
    }

    public boolean performOk() {
        List files = (List)this.viewer.getInput();
        String[] filesString = new String[files.size()];
        int i = 0;
        while (i < files.size()) {
            filesString[i] = ((IFile)files.get(i)).getProjectRelativePath().toString();
            ++i;
        }
        this.webProject.setValue("toc_pathes", filesString);
        try {
            this.webProject.storePreferences();
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
            return false;
        }
        return super.performOk();
    }
}

