/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.WebResourceSelectionListener;
import com.narucy.webpub.ui.WebResourceSelectionAdapter;
import com.narucy.webpub.ui.wizards.EditElementWizard;
import com.narucy.webpub.ui.wizards.EditElementWizardPage;
import com.narucy.webpub.ui.wizards.WebResourceSelectionBlock;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Element;

public class AElementWizardPage
extends EditElementWizardPage {
    Combo frameTargets;
    WebResourceSelectionBlock block;

    public AElementWizardPage() {
        super("AElementWizardPage");
        this.setTitle("Anchor");
        this.setDescription("Anchor element edit speciy link target.");
    }

    public void createChildControl(Composite parent) throws CoreException {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.block = new WebResourceSelectionBlock((IResource)this.getEditFile());
        this.block.getModel().addListener((WebResourceSelectionListener)new WebResourceSelectionAdapter(this){

            public void resourceChanged(IPath path, IResource existResource) {
                AElementWizardPage.this.refreshPreview();
            }
        });
        Control blockControl = this.block.createControl(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        blockControl.setLayoutData((Object)gd);
        Label labe = new Label(parent, 0);
        labe.setText("Target Frame:");
        this.block.setColumnNameWidth(labe.computeSize((int)-1, (int)-1).x);
        this.frameTargets = new Combo(parent, 2052);
        gd = new GridData();
        this.frameTargets.setLayoutData((Object)gd);
        this.frameTargets.add("_self");
        this.frameTargets.add("_top");
        this.frameTargets.add("_blink");
        this.frameTargets.add("_parent");
        this.frameTargets.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AElementWizardPage.this.refreshPreview();
            }
        });
        parent.layout();
        this.block.forceFocus();
        String selText = ((EditElementWizard)this.getWizard()).getSelection().getText();
        switch (this.getEditType()) {
            case 0: {
                break;
            }
            case 1: {
                Element elem = this.getParsedSelectionText();
                if (elem != null) {
                    this.block.getModel().setPath(elem.getAttribute("href"));
                    String item = elem.getAttribute("link");
                    String[] items = this.frameTargets.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(item)) {
                            this.frameTargets.select(i);
                            item = null;
                            break;
                        }
                        ++i;
                    }
                    if (item != null) {
                        this.frameTargets.add(item);
                    }
                }
                EditElementWizardPage.chooseContent(selText);
            }
        }
    }

    public String getPreviewText() {
        Object elem;
        String content = ((EditElementWizard)this.getWizard()).getSelection().getText();
        String href = "";
        String frameTargetName = null;
        if (this.getEditType() == 1) {
            elem = this.getParsedSelectionText();
            href = elem.getAttribute("href");
            frameTargetName = elem.getAttribute("link");
            content = EditElementWizardPage.chooseContent(content);
        }
        if (this.block != null) {
            IPath hrefPath = this.block.getModel().getPath();
            href = hrefPath != null ? hrefPath.toString() : "";
            frameTargetName = this.frameTargets.getText();
        }
        elem = "<a href=\"" + href + "\"";
        if (frameTargetName != null && frameTargetName.length() > 0) {
            elem = String.valueOf(elem) + " target=\"" + frameTargetName + "\"";
        }
        return String.valueOf(elem) + ">" + content + "</a>";
    }
}

