/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.HTMLUtilities;
import com.narucy.webpub.core.WebResourceLinkModel;
import com.narucy.webpub.core.WebResourceSelectionListener;
import com.narucy.webpub.ui.SWTUtilities;
import com.narucy.webpub.ui.WebResourceSelectionAdapter;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.wizards.EditElementWizardPage;
import com.narucy.webpub.ui.wizards.ImageBrowser;
import com.narucy.webpub.ui.wizards.WebResourceSelectionBlock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Element;

public class ImgElementWizardPage
extends EditElementWizardPage {
    ImageBrowser imgBrowser;
    Text altText;
    Text imgWidth;
    Text imgHeight;
    Text previewImgWidth;
    Text previewImgHeight;
    Button browseButton;
    Button fitSizeButton;
    ScrolledComposite imgBrowserBase;
    WebResourceSelectionBlock block;
    ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ImgElementWizardPage.this.refreshPreview();
        }
    };

    protected ImgElementWizardPage() {
        super("ImgElementWizardPage");
        this.setTitle("Image");
        this.setDescription("Edit image element for html.");
    }

    protected void createChildControl(Composite parent) throws CoreException {
        Element elem;
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 9;
        parent.setLayout((Layout)layout);
        this.block = new WebResourceSelectionBlock((IResource)this.getEditFile());
        final WebResourceLinkModel model = this.block.getModel();
        model.addListener((WebResourceSelectionListener)new WebResourceSelectionAdapter(this){

            public void resourceChanged(IPath path, IResource existResource) {
                ImgElementWizardPage.this.refreshPreview();
                if (model.getWebResource() != null) {
                    ImgElementWizardPage.this.refreshImagePreview();
                }
            }
        });
        Control blockControl = this.block.createControl(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        blockControl.setLayoutData((Object)gd);
        Label labe = new Label(parent, 0);
        labe.setText("&Alternate Text:");
        this.altText = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.altText.setLayoutData((Object)gd);
        this.altText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImgElementWizardPage.this.refreshPreview();
            }
        });
        this.block.setColumnNameWidth(labe.computeSize((int)-1, (int)-1).x);
        Group imgSizeSettings = new Group(parent, 0);
        GridLayout imgGroupLayout = new GridLayout(3, false);
        imgGroupLayout.verticalSpacing = 9;
        imgSizeSettings.setLayout((Layout)imgGroupLayout);
        gd = new GridData();
        gd.widthHint = 240;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 1;
        imgSizeSettings.setLayoutData((Object)gd);
        imgSizeSettings.setText("Image Size");
        this.imgWidth = this.createImageSizeText((Composite)imgSizeSettings, "&Width:");
        this.imgHeight = this.createImageSizeText((Composite)imgSizeSettings, "&Height:");
        this.previewImgWidth = ImgElementWizardPage.createImageSizePreviewText((Composite)imgSizeSettings, "Preview Width:");
        this.previewImgHeight = ImgElementWizardPage.createImageSizePreviewText((Composite)imgSizeSettings, "Preview Height:");
        gd = (GridData)this.previewImgHeight.getLayoutData();
        gd.horizontalSpan = 1;
        this.fitSizeButton = new Button((Composite)imgSizeSettings, 8);
        this.fitSizeButton.setLayoutData((Object)new GridData(128));
        this.fitSizeButton.setText("Fit &Size");
        this.fitSizeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImgElementWizardPage.this.fitSize();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite imgPreviewBase = new Composite(parent, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        imgPreviewBase.setLayoutData((Object)gd);
        imgPreviewBase.setLayout((Layout)new GridLayout(2, true));
        labe = new Label(imgPreviewBase, 0);
        gd = new GridData(256);
        gd.verticalAlignment = 3;
        labe.setLayoutData((Object)gd);
        labe.setText("Image Preview:");
        Button button = new Button(imgPreviewBase, 8);
        gd = new GridData(128);
        button.setLayoutData((Object)gd);
        button.setText("Refr&esh");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImgElementWizardPage.this.invokeRefresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.imgBrowserBase = new ScrolledComposite(imgPreviewBase, 2816);
        this.imgBrowser = new ImageBrowser((Composite)this.imgBrowserBase);
        this.imgBrowserBase.setContent((Control)this.imgBrowser);
        this.imgBrowserBase.setAlwaysShowScrollBars(false);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.imgBrowserBase.setLayoutData((Object)gd);
        if (this.getEditType() == 1 && (elem = this.getParsedSelectionText()) != null) {
            model.setPath(elem.getAttribute("src"));
            this.altText.setText(HTMLUtilities.unescape((String)elem.getAttribute("alt")));
            this.imgWidth.setText(elem.getAttribute("width"));
            this.imgHeight.setText(elem.getAttribute("height"));
        }
        if (this.block.getModel().getWebResource() != null) {
            this.refreshImagePreview();
        }
        this.block.forceFocus();
    }

    Text createImageSizeText(Composite base, String label) {
        Label labe = new Label(base, 0);
        labe.setText(label);
        Text text = new Text(base, 2048);
        text.setText("0");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.addVerifyListener(SWTUtilities.NUM_VERIFY_LISTENER);
        text.addModifyListener(this.modifyListener);
        return text;
    }

    static Text createImageSizePreviewText(Composite base, String label) {
        Label labe = new Label(base, 0);
        labe.setText("Preview Width:");
        Text text = new Text(base, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        return text;
    }

    void invokeRefresh() {
        if (this.block.getModel().getWebResource() == null) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            try {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ImgElementWizardPage.this.loadImageAsProgress(monitor);
                    }
                });
            }
            catch (InvocationTargetException e1) {
                WebpubUIPlugin.handleException(e1);
            }
            catch (InterruptedException e1) {
                WebpubUIPlugin.handleException(e1);
            }
        } else {
            this.refreshImagePreview();
        }
    }

    void fitSize() {
        Point previewSize = this.getPreviewImaeSize();
        this.imgWidth.setText(String.valueOf(previewSize.x));
        this.imgHeight.setText(String.valueOf(previewSize.y));
    }

    void loadImageAsProgress(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Load image datas", -1);
            final boolean[] done = new boolean[1];
            Thread th = new Thread(){

                public void run() {
                    ImgElementWizardPage.this.getShell().getDisplay().syncExec(new Runnable(this, done){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ boolean[] val$done;
                        {
                            this.this$1 = var1_1;
                            this.val$done = blArray;
                        }

                        public void run() {
                            7.access$0(this.this$1).refreshImagePreview();
                            this.val$done[0] = true;
                        }
                    });
                }

                static /* synthetic */ ImgElementWizardPage access$0(7 var0) {
                    return var0.ImgElementWizardPage.this;
                }
            };
            th.setPriority(1);
            th.start();
            while (done[0] && !monitor.isCanceled()) {
                Thread.sleep(100L);
                monitor.worked(1);
            }
            th.join();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    void refreshImagePreview() {
        Image img = null;
        try {
            IResource res = this.block.getModel().getWebResource();
            InputStream stream = null;
            if (res != null && res instanceof IFile) {
                res.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                stream = ((IFile)res).getContents();
            } else {
                stream = new URL(this.block.getModel().getPath().toString()).openStream();
            }
            img = this.imgBrowser.browseImage(stream);
        }
        catch (ConnectException ex) {
            this.setMessage(ex.getMessage(), 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setMessage("Specify resource is not found", 2);
        }
        catch (SWTException ex) {
            this.setMessage(ex.getMessage(), 2);
        }
        catch (UnknownHostException ex) {
            this.setMessage(ex.getMessage(), 2);
        }
        catch (MalformedURLException ex) {
            this.setMessage(ex.getMessage(), 2);
        }
        catch (IOException ex) {
            WebpubUIPlugin.handleException(ex);
        }
        catch (CoreException ex) {
            WebpubUIPlugin.handleException((Exception)((Object)ex));
        }
        if (img != null) {
            ImageData data = img.getImageData();
            String w = String.valueOf(data.width);
            this.previewImgWidth.setText(w);
            if (this.imgWidth.getText().equals("0")) {
                this.imgWidth.setText(w);
            }
            String h = String.valueOf(data.height);
            this.previewImgHeight.setText(h);
            if (this.imgHeight.getText().equals("0")) {
                this.imgHeight.setText(h);
            }
            this.fitSizeButton.setEnabled(true);
        } else {
            this.previewImgWidth.setText("");
            this.previewImgHeight.setText("");
            this.imgBrowser.browseImage(null);
            this.fitSizeButton.setEnabled(false);
        }
        Point p = this.imgBrowser.computeSize(-1, -1);
        this.imgBrowser.setSize(p);
        this.imgBrowserBase.setMinSize(p.x, p.y);
        this.imgBrowserBase.redraw(0, 0, p.x, p.y, true);
    }

    public String getPreviewText() {
        Point size = this.getImageSize();
        return "<img src=\"" + this.getImageUrl() + "\"" + " alt=\"" + HTMLUtilities.escape((String)this.getAltitudeText()) + "\"" + " width=\"" + size.x + "\"" + " height=\"" + size.y + "\" />";
    }

    String getImageUrl() {
        return this.block != null && this.block.getModel().getPath() != null ? this.block.getModel().getPath().toString() : "";
    }

    String getAltitudeText() {
        return this.altText != null ? this.altText.getText() : "";
    }

    Point getImageSize() {
        return new Point(this.imgWidth != null ? Integer.parseInt(this.imgWidth.getText()) : 0, this.imgHeight != null ? Integer.parseInt(this.imgHeight.getText()) : 0);
    }

    Point getPreviewImaeSize() {
        return new Point(this.previewImgWidth != null ? Integer.parseInt(this.previewImgWidth.getText()) : 0, this.previewImgHeight != null ? Integer.parseInt(this.previewImgHeight.getText()) : 0);
    }
}

