/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.FileUtilities;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.preset.Preset;
import com.narucy.webpub.core.preset.PresetManager;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocStore;
import com.narucy.webpub.core.toc.Topic;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.views.PresetViewer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class PresetSelectionWizardPage
extends WizardPage {
    static final String PAGE_NAME = "Preset";
    Pattern[] ignoreFilePatterns = new Pattern[]{Pattern.compile("CVS")};
    Preset[] presets;
    PresetViewer viewer;
    Combo combo;

    public PresetSelectionWizardPage() {
        super(PAGE_NAME);
        this.setTitle(PAGE_NAME);
        this.setDescription("Define web site structure. You can select presets that for easy to initialization the store files.");
        this.setImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("wizban/newwebproj_wiz.gif"));
    }

    public void createControl(Composite parent) {
        this.presets = PresetManager.getInstance().getPrests();
        Composite topComp = new Composite(parent, 0);
        topComp.setLayout((Layout)new GridLayout(2, false));
        new Label(topComp, 0).setText("Preset:");
        this.combo = new Combo(topComp, 8);
        this.combo.setLayoutData((Object)new GridData(768));
        int i = 0;
        while (i < this.presets.length) {
            this.combo.add(this.presets[i].getName());
            ++i;
        }
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = PresetSelectionWizardPage.this.combo.getSelectionIndex();
                PresetSelectionWizardPage.this.viewer.setPreset(PresetSelectionWizardPage.this.presets[index]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer = new PresetViewer(topComp, new String[]{"label", "href", "initalHt"});
        GridData gd = new GridData(1812);
        gd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setPreset(this.presets[0]);
        this.combo.select(0);
        this.setControl((Control)topComp);
    }

    public void storePresets(WebProject desc, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Apply preset", 2);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new PresetStoreProc(desc), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            desc.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        Object var3_5 = null;
        monitor.done();
    }

    class PresetStoreProc
    implements IWorkspaceRunnable {
        WebProject webProject;

        PresetStoreProc(WebProject webProj) {
            this.webProject = webProj;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                try {
                    File scriptDir;
                    URL scriptDirUrl;
                    File htDir;
                    URL htDirUrl;
                    File resourceDir;
                    monitor.beginTask("Distribute preset HTML files and folders", -1);
                    Preset preset = PresetSelectionWizardPage.this.presets[PresetSelectionWizardPage.this.combo.getSelectionIndex()];
                    IContainer distHtFolder = this.webProject.getFolder("htsources_folder");
                    IContainer distScriptFolder = this.webProject.getFolder("scripts_folder");
                    URL baseResourcesDir = preset.getInitialResourcesDirectory();
                    if (baseResourcesDir != null && (resourceDir = new File(baseResourcesDir.getFile())).isDirectory()) {
                        FileUtilities.copyWithDirContainFiles((File)resourceDir, (File)this.webProject.getProject().getLocation().toFile(), (Pattern[])PresetSelectionWizardPage.this.ignoreFilePatterns);
                    }
                    if ((htDirUrl = preset.getInitialHtsDirectory()) != null && (htDir = new File(htDirUrl.getFile())).isDirectory()) {
                        FileUtilities.copyWithDirContainFiles((File)htDir, (File)distHtFolder.getLocation().toFile(), (Pattern[])PresetSelectionWizardPage.this.ignoreFilePatterns);
                    }
                    if ((scriptDirUrl = preset.getScriptsDirectory()) != null && (scriptDir = new File(scriptDirUrl.getFile())).isDirectory()) {
                        FileUtilities.copyWithDirContainFiles((File)scriptDir, (File)distScriptFolder.getLocation().toFile(), (Pattern[])PresetSelectionWizardPage.this.ignoreFilePatterns);
                    }
                    monitor.worked(10);
                    Toc toc = PresetSelectionWizardPage.this.viewer.getToc();
                    TocStore.storeToc((Toc)toc, (IFile)this.webProject.getProject().getFile("toc.xml"));
                    Topic[] topics = toc.getAllTopics();
                    int i = 0;
                    while (i < topics.length) {
                        Topic topic = topics[i];
                        String href = topic.getHref();
                        if (href != null) {
                            Object var17_19;
                            IFile file = distHtFolder.getFile((IPath)new Path(href));
                            URL initUrl = PresetSelectionWizardPage.this.viewer.getInitialURL(topic);
                            ArrayList<IFile> folders = new ArrayList<IFile>(0);
                            IFile res = file;
                            while ((res = res.getParent()) instanceof IFolder && !res.exists()) {
                                folders.add(res);
                            }
                            int j = folders.size() - 1;
                            while (j >= 0) {
                                ((IFolder)folders.get(j)).create(true, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                --j;
                            }
                            InputStream is = initUrl.openStream();
                            try {
                                file.create(is, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            catch (Throwable throwable) {
                                var17_19 = null;
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable;
                            }
                            var17_19 = null;
                            if (is != null) {
                                is.close();
                            }
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    WebpubUIPlugin.handleException(e);
                }
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                monitor.done();
                throw throwable;
            }
            Object var19_23 = null;
            monitor.done();
        }
    }
}

