/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.core.template.TemplateParseException;
import com.narucy.webpub.core.template.TemplateParser;
import com.narucy.webpub.ui.wizards.IPreviewer;
import com.narucy.webpub.ui.wizards.InsertTemplateWizard;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class TemplateContentSelectionWizardPage
extends WizardPage
implements IPreviewer {
    Text preview;
    Combo filesCombo;
    Combo definedLineCombo;
    String tmplName = null;
    IFile[] files = null;
    Template[] candidacies = null;

    public TemplateContentSelectionWizardPage() {
        super("TemplateContentSelectionWizardPage");
        this.setTitle("Template Content Selection");
        this.setDescription("Template content is subtlety different in CONTENT marks, specify your want to insert template text.");
    }

    public void setTemplateName(String tmplName) {
        this.tmplName = tmplName;
        this.refreshDefinedFiles();
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        this.setControl((Control)base);
        base.setLayout((Layout)new GridLayout(2, false));
        new Label(base, 0).setText("&Use as content:");
        this.filesCombo = new Combo(base, 2056);
        this.filesCombo.setLayoutData((Object)new GridData(768));
        this.filesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplateContentSelectionWizardPage.this.updateFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(base, 0).setText("&Preview:");
        this.definedLineCombo = new Combo(base, 2056);
        GridData gd = new GridData(128);
        gd.widthHint = 100;
        this.definedLineCombo.setLayoutData((Object)gd);
        this.definedLineCombo.setEnabled(false);
        this.definedLineCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplateContentSelectionWizardPage.this.updateDefinedLine();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.preview = InsertTemplateWizard.createPreviewText(base);
        this.refreshDefinedFiles();
        this.filesCombo.forceFocus();
    }

    void refreshDefinedFiles() {
        if (this.filesCombo != null && this.tmplName != null) {
            this.filesCombo.removeAll();
            TemplateManager tmplMgr = ((InsertTemplateWizard)this.getWizard()).getTemplateManager();
            this.files = tmplMgr.getTemplateDefinedFiles(this.tmplName);
            int i = 0;
            while (i < this.files.length) {
                this.filesCombo.add(this.files[i].getFullPath().toString());
                ++i;
            }
            this.filesCombo.select(0);
            this.updateFile();
        }
    }

    void updateFile() {
        ((InsertTemplateWizard)this.getWizard()).getTemplateManager();
        IFile file = this.files[this.filesCombo.getSelectionIndex()];
        try {
            Template tmpl = TemplateParser.getInstance().parse(file);
            this.setErrorMessage(null);
            this.candidacies = tmpl.getAllTemplates(this.tmplName);
            this.definedLineCombo.removeAll();
            this.definedLineCombo.setEnabled(this.candidacies.length > 1);
            int i = 0;
            while (i < this.candidacies.length) {
                this.definedLineCombo.add(this.candidacies[i].getProperty((Object)"find_line_number").toString());
                ++i;
            }
            this.definedLineCombo.select(0);
            this.updateDefinedLine();
        }
        catch (TemplateParseException templateParseException) {
            this.setErrorMessage("Can not parse a specified file.");
        }
        catch (IOException iOException) {
            this.setErrorMessage("Can not read a file.");
        }
        catch (CoreException coreException) {
            this.setErrorMessage("Can not read a file.");
        }
    }

    void updateDefinedLine() {
        this.preview.setText(this.candidacies[this.definedLineCombo.getSelectionIndex()].getJoinedLines());
    }

    public String getPreviewText() {
        return this.preview != null ? this.preview.getText().replaceAll("\r", "") : null;
    }
}

