/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import com.narucy.webpub.core.InterpreterCheckResult;
import com.narucy.webpub.core.TextReader;
import com.narucy.webpub.core.WebpubPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InterpreterCheckerManager {
    static InterpreterCheckerManager instance = null;
    String toolCommandPath;
    HashMap checkerEntries = new HashMap();

    public static InterpreterCheckerManager getInstance() {
        if (instance == null) {
            instance = new InterpreterCheckerManager();
        }
        return instance;
    }

    private InterpreterCheckerManager() {
        WebpubPlugin plugin = WebpubPlugin.getDefault();
        this.toolCommandPath = plugin.find((IPath)new Path("scripts/bin/checktool.rb")).getFile();
        String[] entries = new String[]{"interpreter", "scripts/lib/webpub/interpreter_checker.rb", "WebPub::InterpreterChecker", "Web Publisher requires Ruby that is foundation technorogies for document publish version is and need to version 1.8 or higher. http:///www.ruby-lang.org", "amrita", "scripts/lib/webpub/amrita_checker.rb", "WebPub::AmritaChecker", "Amrita is a a html/xhtml template library for Ruby. http://raa.ruby-lang.org/list.rhtml?name=amrita", "rd", "scripts/lib/webpub/rd_checker.rb", "WebPub::RDChecker", "RD is document RDtool is RD formater and utilities.. http://raa.ruby-lang.org/list.rhtml?name=rdtool"};
        int i = 0;
        while (i < entries.length) {
            URL url = plugin.find((IPath)new Path(entries[i + 1]));
            String fullPath = url.getFile();
            this.checkerEntries.put(entries[i], new String[]{fullPath, entries[i + 2], entries[i + 3]});
            i += 4;
        }
    }

    public String[] getGlobalEntryKeys() {
        return this.checkerEntries.keySet().toArray(new String[this.checkerEntries.size()]);
    }

    public InterpreterCheckResult check(String interpreter) throws CoreException {
        return this.check(interpreter, this.getGlobalEntryKeys());
    }

    public String getDescription(String key) {
        if (this.checkerEntries.containsKey(key)) {
            return ((String[])this.checkerEntries.get(key))[2];
        }
        return null;
    }

    String createArguments(File resultDistFile, String[] keys) {
        StringBuffer buff = new StringBuffer(String.valueOf(this.toolCommandPath) + ' ');
        buff.append(String.valueOf(resultDistFile.toString()) + ' ');
        int i = 0;
        while (i < keys.length) {
            String k = keys[i];
            if (!this.checkerEntries.containsKey(k)) {
                return null;
            }
            String[] entry = (String[])this.checkerEntries.get(k);
            buff.append(String.valueOf(k) + ' ' + entry[0] + ' ' + entry[1] + ' ');
            ++i;
        }
        return buff.toString();
    }

    public InterpreterCheckResult check(String interpreter, String[] keys) throws CoreException {
        if (!new File(interpreter).exists()) {
            InterpreterCheckResult res = new InterpreterCheckResult();
            res.put("interpreter", "Interpreter not found", 3);
            return res;
        }
        File resultDistFile = new File(System.getProperty("java.io.tmpdir"), String.valueOf(String.valueOf(System.currentTimeMillis())) + "InterpreterEnviornmentChecker.result");
        try {
            String args = this.createArguments(resultDistFile, keys);
            Process process = WebpubPlugin.rubyExec(interpreter, args, null);
            InterpreterCheckerManager.readAllStream(process.getErrorStream());
            InterpreterCheckerManager.readAllStream(process.getInputStream());
            int code = process.waitFor();
            if (code == 0) {
                return this.createResult(resultDistFile);
            }
            throw new IOException("IO error occation in checking ruby interpreter enviornment.");
        }
        catch (InterruptedException e) {
            WebpubPlugin.handleException(e);
        }
        catch (IOException e) {
            WebpubPlugin.handleException(e);
        }
        return null;
    }

    static void readAllStream(final InputStream stream) {
        new Thread(){

            public void run() {
                new TextReader(stream).joinedLines();
            }
        }.start();
    }

    InterpreterCheckResult createResult(File resultDistFile) throws IOException {
        TextReader reader = new TextReader(new FileInputStream(resultDistFile));
        InterpreterCheckResult result = new InterpreterCheckResult();
        while (reader.hasNext()) {
            String[] entries = reader.nextLine().split(",");
            result.put(entries[0], entries[1], Integer.parseInt(entries[2]));
        }
        return result;
    }
}

