/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class WebProjectConfigurationLoader052 {
    static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    WebProjectConfigurationLoader052() {
    }

    public static boolean reloadDescription(WebProject wp) {
        try {
            IProject proj = wp.getProject();
            IFile descriptionFile = proj.getFile(".webproject");
            if (!descriptionFile.exists()) {
                return false;
            }
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(descriptionFile.getContents());
            Element element = doc.getDocumentElement();
            wp.setValue("htsources_folder", WebProjectConfigurationLoader052.choosePathAsElements(element, "htSourcesFolder"));
            wp.setValue("scripts_folder", WebProjectConfigurationLoader052.choosePathAsElements(element, "scriptsFolder"));
            wp.setValue("publish_folder", WebProjectConfigurationLoader052.choosePathAsElements(element, "publishFolder"));
            return true;
        }
        catch (ParserConfigurationException e) {
            WebpubPlugin.handleException(e);
        }
        catch (IOException e) {
            WebpubPlugin.handleException(e);
        }
        catch (SAXException e) {
            WebpubPlugin.handleException(e);
        }
        catch (CoreException e) {
            WebpubPlugin.handleException((Exception)((Object)e));
        }
        return false;
    }

    static String choosePathAsElements(Element element, String name) throws CoreException {
        Node node = element.getElementsByTagName(name).item(0);
        if (node != null && node instanceof Element) {
            return ((Element)node).getAttribute("path");
        }
        return null;
    }
}

