/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.preset;

import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXException;

public class Preset {
    String name;
    URL[] htSelectionURLs;
    URL baseDirectory;
    URL tocURL;
    URL defaultSelectionURL;
    URL initialResourcesDirectory;
    URL initialHtsDirectory;
    URL scriptsDirectory;

    public Preset(String name, URL baseDirectory, String tocPath, String[] htSelectionPaths, String defaultSelectionPath, String htDirectoryPath, String initialResourceDirectoryPath, String scriptsDirectoryPath) throws MalformedURLException {
        this.name = name;
        this.baseDirectory = baseDirectory;
        this.tocURL = new URL(baseDirectory, tocPath);
        this.htSelectionURLs = new URL[htSelectionPaths.length];
        int i = 0;
        while (i < htSelectionPaths.length) {
            URL f;
            String path = htSelectionPaths[i];
            this.htSelectionURLs[i] = f = new URL(baseDirectory, path);
            if (path.equals(defaultSelectionPath)) {
                this.defaultSelectionURL = f;
            }
            ++i;
        }
        if (htDirectoryPath != null) {
            this.initialHtsDirectory = new URL(baseDirectory, htDirectoryPath);
        }
        if (initialResourceDirectoryPath != null) {
            this.initialResourcesDirectory = new URL(baseDirectory, initialResourceDirectoryPath);
        }
        if (scriptsDirectoryPath != null) {
            this.scriptsDirectory = new URL(baseDirectory, scriptsDirectoryPath);
        }
    }

    public Toc createToc() throws SAXException, CoreException, IOException {
        return TocFactory.createToc(this.tocURL.openStream());
    }

    public URL[] getHtSelectionURLs() throws IOException, CoreException {
        return (URL[])this.htSelectionURLs.clone();
    }

    public URL getDefaultSelectionURL() {
        return this.defaultSelectionURL;
    }

    public String getName() {
        return this.name;
    }

    public URL getInitialHtsDirectory() {
        return this.initialHtsDirectory;
    }

    public URL getScriptsDirectory() {
        return this.scriptsDirectory;
    }

    public URL getInitialResourcesDirectory() {
        return this.initialResourcesDirectory;
    }

    public URL getBaseDirectory() {
        return this.baseDirectory;
    }
}

