/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.preset;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.preset.Preset;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PresetManager {
    public static final String ID_PRESETS_EXTENSION = "com.narucy.webpub.core.presets";
    static PresetManager instance = new PresetManager();
    ArrayList presets = null;

    public static PresetManager getInstance() {
        return instance;
    }

    public Preset[] getPrests() {
        if (this.presets == null) {
            this.init();
        }
        return this.presets.toArray(new Preset[this.presets.size()]);
    }

    void init() {
        this.presets = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(ID_PRESETS_EXTENSION);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] elems = ext.getConfigurationElements();
            int j = 0;
            while (j < elems.length) {
                IConfigurationElement elem = elems[j];
                if (elem.getName().equals("preset")) {
                    try {
                        this.presets.add(PresetManager.createPreset(elem));
                    }
                    catch (MalformedURLException e) {
                        WebpubPlugin.handleException(e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    static Preset createPreset(IConfigurationElement elem) throws MalformedURLException {
        IPluginDescriptor descriptor = elem.getDeclaringExtension().getDeclaringPluginDescriptor();
        URL baseDirectory = descriptor.find((IPath)new Path("/"));
        String name = elem.getAttribute("name");
        if (name == null) {
            throw new IllegalArgumentException("Attribute is not setted: name");
        }
        String tocFileName = elem.getAttribute("toc");
        if (tocFileName == null) {
            throw new IllegalArgumentException("Attribute is not setted: toc");
        }
        ArrayList<String> htSelections = new ArrayList<String>();
        String defaultSelection = null;
        IConfigurationElement[] elements = elem.getChildren();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elemName = element.getName();
            if (elemName.equals("htSelections")) {
                IConfigurationElement[] htElems = element.getChildren();
                int j = 0;
                while (j < htElems.length) {
                    IConfigurationElement e = htElems[j];
                    if (e.getName().equals("htItem")) {
                        String path = e.getAttribute("path");
                        if (path == null) {
                            throw new IllegalArgumentException("htItem element need to path attribute");
                        }
                        htSelections.add(path);
                        String defaultItem = e.getAttribute("default");
                        if (defaultItem != null && Boolean.valueOf(defaultItem).booleanValue()) {
                            defaultSelection = path;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        String initialHtsDirectory = elem.getAttribute("initialHts");
        String initialResourcesDirectory = elem.getAttribute("initialResources");
        String initialScriptsDirectory = elem.getAttribute("initialScripts");
        return new Preset(name, baseDirectory, tocFileName, htSelections.toArray(new String[htSelections.size()]), defaultSelection, initialHtsDirectory, initialResourcesDirectory, initialScriptsDirectory);
    }
}

