/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.toc;

import com.narucy.webpub.core.toc.TocEvent;
import com.narucy.webpub.core.toc.TocListener;
import com.narucy.webpub.core.toc.Topic;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;

public class Toc
extends Topic {
    ArrayList listenerList = new ArrayList();
    ArrayList events = null;
    IFile tocFile;

    public Toc(String href, String label) {
        super(href, label, null);
    }

    public void addTocListener(TocListener l) {
        this.listenerList.add(l);
    }

    public void removeTocListener(TocListener l) {
        this.listenerList.remove(l);
    }

    protected TocListener[] getListeners() {
        return this.listenerList.toArray(new TocListener[this.listenerList.size()]);
    }

    protected void stockEvent(TocEvent e) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        this.events.add(e);
    }

    public void fireChanged() {
        if (this.events == null) {
            return;
        }
        TocEvent[] es = this.events.toArray(new TocEvent[this.events.size()]);
        this.events = null;
        TocListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].topicChanged(es);
            ++i;
        }
    }

    public void removeSubtopics() {
        Topic[] ts = this.getSubtopics();
        int i = 0;
        while (i < ts.length) {
            this.removeTopic(ts[i]);
            ++i;
        }
    }

    public Topic[] getAllTopics() {
        ArrayList list = new ArrayList();
        Toc.searchTopics(this.getSubtopics(), list);
        return list.toArray(new Topic[list.size()]);
    }

    static void searchTopics(Topic[] topics, ArrayList list) {
        int i = 0;
        while (i < topics.length) {
            Topic topic = topics[i];
            list.add(topic);
            Toc.searchTopics(topic.getSubtopics(), list);
            ++i;
        }
    }

    public Topic findTopic(String href) {
        Topic[] topics = this.getAllTopics();
        int i = 0;
        while (i < topics.length) {
            Topic t = topics[i];
            if (t.getHref() != null && t.getHref().equals(href)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public Topic getTopic(String href) {
        Topic[] topics = this.getAllTopics();
        int i = 0;
        while (i < topics.length) {
            Topic topic = topics[i];
            if (topic.getHref().equals(href)) {
                return topic;
            }
            ++i;
        }
        return null;
    }

    public IFile getTocFile() {
        return this.tocFile;
    }

    public void setTocFile(IFile f) {
        this.tocFile = f;
    }

    public void applyToc(Toc toc) {
        if (this.equals((Object)toc)) {
            return;
        }
        this.removeSubtopics();
        String[] keys = toc.getAttributeKeys();
        int i = 0;
        while (i < keys.length) {
            String k = keys[i];
            this.setAttribute(k, toc.getAttribute(k));
            ++i;
        }
        Topic[] ts = toc.getSubtopics();
        int i2 = 0;
        while (i2 < ts.length) {
            this.addTopic((Topic)((Object)ts[i2].clone()));
            ++i2;
        }
    }

    public Object clone() {
        Toc toc = new Toc(this.getHref(), this.getLabel());
        toc.applyToc(this);
        return toc;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Toc toc = (Toc)((Object)obj);
            IFile f = toc.getTocFile();
            return f == this.tocFile || (f != null ? f.equals((Object)this.tocFile) : this.tocFile.equals((Object)f));
        }
        return false;
    }
}

