/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.toc;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocCheckHandler;
import com.narucy.webpub.core.toc.TocHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TocFactory {
    public static final String ID_MARKER_TOC_PROBLEM = "com.narucy.webpub.core.toc.toc_problem";
    static final String[] TOC_FILE_EXTENSIONS = new String[]{"toc", "xml"};
    static SAXParserFactory factory = SAXParserFactory.newInstance();

    static {
        Arrays.sort(TOC_FILE_EXTENSIONS);
    }

    private TocFactory() {
    }

    public static Toc createToc(IFile file) throws CoreException {
        if (file.isAccessible()) {
            IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            int i = 0;
            while (i < markers.length) {
                IMarker m = markers[i];
                if (Boolean.TRUE.equals(m.getAttribute(ID_MARKER_TOC_PROBLEM))) {
                    m.delete();
                }
                ++i;
            }
            InputStream stream = file.getContents();
            try {
                Toc toc = TocFactory.createToc(stream);
                toc.setTocFile(file);
                return toc;
            }
            catch (SAXException e) {
                if (e.getException() != null) {
                    e.getException().printStackTrace();
                }
                e.printStackTrace();
                IMarker m = file.createMarker("org.eclipse.core.resources.problemmarker");
                m.setAttribute(ID_MARKER_TOC_PROBLEM, true);
                m.setAttribute("message", (Object)e.getLocalizedMessage());
            }
        }
        return null;
    }

    public static Toc createToc(String tocCode) throws SAXException, CoreException {
        InputSource stream = new InputSource(new StringReader(tocCode));
        try {
            try {
                TocHandler handler = new TocHandler();
                factory.newSAXParser().parse(stream, (DefaultHandler)handler);
                return handler.getToc();
            }
            catch (ParserConfigurationException e) {
                throw new CoreException(TocFactory.toStatus(e));
            }
        }
        catch (IOException e) {
            throw new CoreException(TocFactory.toStatus(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Toc createToc(InputStream stream) throws SAXException, CoreException {
        try {
            Toc toc;
            try {
                try {
                    TocHandler handler = new TocHandler();
                    factory.newSAXParser().parse(stream, (DefaultHandler)handler);
                    toc = handler.getToc();
                    Object var2_5 = null;
                }
                catch (ParserConfigurationException e) {
                    throw new CoreException(TocFactory.toStatus(e));
                }
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                stream.close();
                throw throwable;
            }
            stream.close();
            return toc;
        }
        catch (IOException e) {
            throw new CoreException(TocFactory.toStatus(e));
        }
    }

    static IStatus toStatus(Exception e) {
        return new Status(4, "com.narucy.webpub.core", 0, e.getMessage(), (Throwable)e);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTocResources(IResource res) {
        block12: {
            if (res instanceof IStorage == false) return false;
            if (res.getFileExtension() == null) return false;
            if (Arrays.binarySearch(TocFactory.TOC_FILE_EXTENSIONS, res.getFileExtension()) < 0) return false;
            handler = new TocCheckHandler();
            stream = null;
            try {
                try {
                    stream = ((IStorage)res).getContents();
                    TocFactory.factory.newSAXParser().parse(stream, (DefaultHandler)handler);
                    var5_3 = handler.isToc();
                    var3_4 = null;
                    if (stream == null) return var5_3;
                }
                catch (SAXException v0) {
                    break block12;
                }
                catch (IOException v1) {
                    break block12;
                }
                catch (ParserConfigurationException v2) {
                    break block12;
                }
                catch (CoreException v3) {
                    break block12;
                }
            }
            catch (Throwable var4_10) {
                var3_5 = null;
                if (stream == null) throw var4_10;
                try {
                    stream.close();
                    throw var4_10;
                }
                catch (IOException ex) {
                    WebpubPlugin.handleException(ex);
                }
                throw var4_10;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 109->116)] { 
lbl35:
            // 1 sources

            stream.close();
            return var5_3;
lbl37:
            // 1 sources

            catch (IOException ex) {
                WebpubPlugin.handleException(ex);
            }
            return var5_3;
        }
        var3_6 = null;
        if (stream == null) return false;
        try {}
        catch (IOException ex) {
            WebpubPlugin.handleException(ex);
            return false;
        }
        stream.close();
        return false;
    }
}

