/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.linkcheck.core;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.debug.WebpubDebugPlugin;
import com.narucy.webpub.linkcheck.core.CheckResoutMonitor;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public class LinkCheckConfigurationDelegate
implements ILaunchConfigurationDelegate,
LinkCheckConstants {
    static final List EMPTY_LIST = new ArrayList();
    String checkScriptPath = WebpubDebugPlugin.getDefault().find((IPath)new Path("scripts/bin/checklink.rb")).getFile();
    int sleepTime = 1000;

    String renderCommandArguments(ILaunchConfiguration config) throws CoreException {
        List httpCodes;
        List files;
        List exts;
        StringBuffer buff = new StringBuffer(this.checkScriptPath);
        List regexps = config.getAttribute("com.narucy.webpub.linkcheck.ignoreRegexp", EMPTY_LIST);
        if (regexps.size() > 0) {
            buff.append(" --ingore_link_regexp ");
            LinkCheckConfigurationDelegate.distListWithComma(buff, regexps);
        }
        if ((exts = config.getAttribute("com.narucy.webpub.linkcheck.extensions", EMPTY_LIST)).size() > 0) {
            buff.append(" --exts ");
            LinkCheckConfigurationDelegate.distListWithComma(buff, exts);
        }
        if ((files = config.getAttribute("com.narucy.webpub.linkcheck.checkResources", EMPTY_LIST)).size() > 0) {
            buff.append(" --files ");
            LinkCheckConfigurationDelegate.distListWithComma(buff, files);
        }
        if ((httpCodes = config.getAttribute("com.narucy.webpub.linkcheck.httpcode", EMPTY_LIST)).size() > 0) {
            buff.append(" --http_error_codes ");
            LinkCheckConfigurationDelegate.distListWithComma(buff, httpCodes);
        }
        return buff.toString();
    }

    static void distListWithComma(StringBuffer buff, List ls) {
        int i = 0;
        int len = ls.size();
        while (i < len) {
            buff.append((String)ls.get(i));
            if (i != len - 1) {
                buff.append(',');
            }
            ++i;
        }
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor moni) throws CoreException {
        IProgressMonitor monitor;
        block8: {
            monitor = moni != null ? moni : new NullProgressMonitor();
            try {
                try {
                    monitor.beginTask("Starting link check", -1);
                    List resources = config.getAttribute("com.narucy.webpub.linkcheck.checkResources", new ArrayList());
                    final ArrayList<IContainer> livingResources = new ArrayList<IContainer>();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    int i = 0;
                    while (i < resources.size()) {
                        Path path = new Path((String)resources.get(i));
                        IContainer r = root.getContainerForLocation((IPath)path);
                        if (!r.isAccessible()) {
                            r = root.getFileForLocation((IPath)path);
                        }
                        if (r.isAccessible()) {
                            livingResources.add(r);
                        }
                        ++i;
                    }
                    workspace.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            LinkCheckConfigurationDelegate.deleteMarkers(livingResources.toArray(new IResource[livingResources.size()]));
                        }
                    }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    String args = this.renderCommandArguments(config);
                    Process nativeProcess = WebpubPlugin.getDefault().rubyExec(args, null);
                    final IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)nativeProcess, (String)"Link Checker");
                    IStreamsProxy proxy = process.getStreamsProxy();
                    final CheckResoutMonitor resultMonitor = new CheckResoutMonitor(proxy);
                    final boolean background = config.getAttribute("com.narucy.webpub.linkcheck.background", false);
                    Runnable run = new Runnable(){

                        public void run() {
                            while (!monitor.isCanceled() && !process.isTerminated()) {
                                try {
                                    Thread.sleep(LinkCheckConfigurationDelegate.this.sleepTime);
                                }
                                catch (InterruptedException e) {
                                    WebpubDebugPlugin.handleException(e);
                                }
                                IFile chkFile = resultMonitor.getCurrentCheckFile();
                                resultMonitor.getFinishedFileCount();
                                if (background || chkFile == null) continue;
                                monitor.setTaskName("Checking " + chkFile.getFullPath());
                            }
                        }
                    };
                    if (background) {
                        new Thread(run).start();
                        break block8;
                    }
                    run.run();
                }
                catch (IOException e) {
                    WebpubDebugPlugin.handleException(e);
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                monitor.done();
                throw throwable;
            }
        }
        Object var17_21 = null;
        monitor.done();
    }

    static void deleteMarkers(IResource[] rs) throws CoreException {
        int i = 0;
        while (i < rs.length) {
            IResource r = rs[i];
            if (r.isAccessible()) {
                LinkCheckConfigurationDelegate.deleteMarker(r);
                if (r instanceof IContainer) {
                    LinkCheckConfigurationDelegate.deleteMarkers(((IContainer)r).members());
                }
            }
            ++i;
        }
    }

    static void deleteMarker(IResource res) throws CoreException {
        IMarker[] markers = res.findMarkers(null, true, 0);
        int i = 0;
        while (i < markers.length) {
            IMarker m = markers[i];
            if (Boolean.TRUE.equals(m.getAttribute("com.narucy.webpub.debug.core.linkCheck"))) {
                m.delete();
            }
            ++i;
        }
    }
}

