/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.linkcheck.ui;

import com.narucy.webpub.debug.WebpubDebugPlugin;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class HTTPLinkCheckLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements LinkCheckConstants {
    static final ArrayList EMPTY_LIST = new ArrayList();
    static final String[] ERRORS = new String[]{"400", "Bud Request", "401", "Unauthorized", "402", "Payment Required", "403", "Forbidden", "404", "Not Found", "405", "Method Not Allowed", "406", "Not Acceptable", "407", "Proxy Authentication Required", "408", "Request Timeout", "409", "Conflict", "410", "Gone", "411", "Length Required", "412", "Precondition Failed", "413", "Required Entry Too Large", "415", "Unsupported Media Type", "500", "Inetrnal Sever Error", "501", "Not Implemented", "502", "Bad Gateway", "503", "Service Unavailable", "504", "Gateway Timeout", "505", "HTTP Version Not Supported"};
    static final String[] DEFAULT_SELECTED = new String[]{"404", "500", "501", "502", "503", "504", "505"};
    Image imageIcon = null;
    CheckboxTableViewer codesViewer;
    Button checkAllButton;
    SelectionListener buttonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == HTTPLinkCheckLaunchConfigurationTab.this.checkAllButton) {
                HTTPLinkCheckLaunchConfigurationTab.this.handleSelectAll();
                HTTPLinkCheckLaunchConfigurationTab.this.getLaunchConfigurationDialog().updateButtons();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };

    HTTPLinkCheckLaunchConfigurationTab() {
    }

    void handleSelectAll() {
        this.codesViewer.setAllChecked(true);
    }

    public void createControl(Composite parent) {
        this.imageIcon = WebpubDebugPlugin.getImageDescriptor("ctool16/hticon.gif").createImage();
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, true));
        new Label(base, 0).setText("&Catch Errors:");
        this.createCodeListControl(base).setLayoutData((Object)new GridData(1808));
        this.setControl((Control)base);
    }

    Control createCodeListControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.codesViewer = CheckboxTableViewer.newCheckList((Composite)base, (int)2816);
        this.codesViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.codesViewer.setColumnProperties(new String[]{"code", "description"});
        this.codesViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return (String)element;
                }
                if (columnIndex == 1) {
                    int i = 0;
                    while (i < ERRORS.length) {
                        if (ERRORS[i].equals(element)) {
                            return ERRORS[i + 1];
                        }
                        i += 2;
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return property.equals("code") || property.equals("description");
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.codesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        String[] codes = new String[ERRORS.length / 2];
        int i = 0;
        int j = 0;
        while (i < ERRORS.length) {
            codes[j] = ERRORS[i];
            i += 2;
            ++j;
        }
        Table t = this.codesViewer.getTable();
        t.setLinesVisible(true);
        t.setHeaderVisible(true);
        new TableColumn(t, 16384).setText("Code");
        new TableColumn(t, 16384).setText("Description");
        this.codesViewer.setInput((Object)codes);
        this.codesViewer.refresh();
        TableColumn[] cols = t.getColumns();
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2].pack();
            ++i2;
        }
        this.checkAllButton = this.createButton(base, "Check &All");
        this.codesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                HTTPLinkCheckLaunchConfigurationTab.this.checkAllButton.setEnabled(HTTPLinkCheckLaunchConfigurationTab.this.codesViewer.getCheckedElements().length < ERRORS.length);
                HTTPLinkCheckLaunchConfigurationTab.this.setDirty(true);
                HTTPLinkCheckLaunchConfigurationTab.this.getLaunchConfigurationDialog().updateButtons();
            }
        });
        return base;
    }

    Button createButton(Composite parent, String name) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.addSelectionListener(this.buttonListener);
        button.setLayoutData((Object)new GridData(258));
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("com.narucy.webpub.linkcheck.httpcode", Arrays.asList(DEFAULT_SELECTED));
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            this.codesViewer.setCheckedElements(conf.getAttribute("com.narucy.webpub.linkcheck.httpcode", Arrays.asList(DEFAULT_SELECTED)).toArray());
        }
        catch (CoreException e) {
            WebpubDebugPlugin.handleException((Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        Object[] codes = this.codesViewer.getCheckedElements();
        wc.setAttribute("com.narucy.webpub.linkcheck.httpcode", Arrays.asList(codes));
    }

    public String getName() {
        return "&Http";
    }

    public Image getImage() {
        return this.imageIcon;
    }

    public void dispose() {
        if (this.imageIcon != null) {
            this.imageIcon.dispose();
        }
        super.dispose();
    }
}

