/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.linkcheck.ui;

import com.narucy.webpub.debug.WebpubDebugPlugin;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class LinkCheckConfigurationTab
extends AbstractLaunchConfigurationTab
implements LinkCheckConstants {
    static final ArrayList EMPTY_LIST = new ArrayList();
    static final String[] ORIGINAL_CHECKERS = new String[]{"http", "ftp"};
    ArrayList ignoreRegexps = new ArrayList();
    ArrayList checkSchemes = new ArrayList();
    Image iconImage = null;
    ListViewer ignoreRegexpViewer;
    CheckboxTableViewer schemeViewer;
    Button addRegexpButton;
    Button removeRegexpButton;
    Button addCheckerButton;
    Button removeCheckerButton;
    Button backgroundButton;
    SelectionListener listener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == LinkCheckConfigurationTab.this.addRegexpButton) {
                LinkCheckConfigurationTab.this.handleAddRegexp();
            }
            if (e.widget == LinkCheckConfigurationTab.this.removeRegexpButton) {
                LinkCheckConfigurationTab.this.handleRemoveRegexp();
            }
            if (e.widget == LinkCheckConfigurationTab.this.addCheckerButton) {
                LinkCheckConfigurationTab.this.handleAddChecker();
            }
            if (e.widget == LinkCheckConfigurationTab.this.removeCheckerButton) {
                LinkCheckConfigurationTab.this.handleRemoveChecker();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };

    public LinkCheckConfigurationTab() {
        this.checkSchemes.addAll(Arrays.asList(ORIGINAL_CHECKERS));
    }

    public void createControl(Composite parent) {
        this.iconImage = WebpubDebugPlugin.getImageDescriptor("ctool16/link_checker.gif").createImage();
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        this.backgroundButton = new Button(base, 32);
        this.backgroundButton.setText("&Background");
        new Label(base, 0).setText("&Check Schemes:");
        this.createCheckSchemesSelectionControl(base).setLayoutData((Object)new GridData(1808));
        new Label(base, 0).setText("&Ignore Regexps:");
        this.createIgnoreRegexpsControl(base).setLayoutData((Object)new GridData(1808));
        Button clearMarkerButton = new Button(base, 8);
        clearMarkerButton.setText("&Clear Link Check Markers");
        clearMarkerButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LinkCheckConfigurationTab.this.deleteAllMarkers();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.schemeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                LinkCheckConfigurationTab.this.getLaunchConfigurationDialog().updateButtons();
            }
        });
        this.setControl((Control)base);
    }

    void deleteAllMarkers() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker[] mks = ResourcesPlugin.getWorkspace().getRoot().findMarkers(null, false, 2);
                    int i = 0;
                    while (i < mks.length) {
                        IMarker m = mks[i];
                        if (Boolean.TRUE.equals(m.getAttribute("com.narucy.webpub.debug.core.linkCheck"))) {
                            m.delete();
                        }
                        ++i;
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            WebpubDebugPlugin.handleException((Exception)((Object)e));
        }
    }

    Control createCheckSchemesSelectionControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.schemeViewer = CheckboxTableViewer.newCheckList((Composite)base, (int)2816);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.schemeViewer.getControl().setLayoutData((Object)gd);
        this.schemeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.schemeViewer.setInput((Object)this.checkSchemes);
        this.addCheckerButton = this.createButton(base, "&Add Checker");
        this.addCheckerButton.setEnabled(false);
        this.removeCheckerButton = this.createButton(base, "&Remove Checker");
        this.removeCheckerButton.setEnabled(false);
        return base;
    }

    Control createIgnoreRegexpsControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.ignoreRegexpViewer = new ListViewer(base);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.ignoreRegexpViewer.getControl().setLayoutData((Object)gd);
        this.ignoreRegexpViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ignoreRegexpViewer.setInput((Object)this.ignoreRegexps);
        this.addRegexpButton = this.createButton(base, "A&dd Ignore URL Regexp");
        this.removeRegexpButton = this.createButton(base, "R&emove Ignore URL Regexp");
        return base;
    }

    Button createButton(Composite parent, String name) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.addSelectionListener(this.listener);
        button.setLayoutData((Object)new GridData(258));
        return button;
    }

    void handleAddRegexp() {
        InputDialog input = new InputDialog(this.getShell(), "Regexp", "Input ignore target for a checker appears url.", null, new IInputValidator(){

            public String isValid(String v) {
                if (v.length() == 0) {
                    return "Input any values";
                }
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException e) {
                    return e.getMessage();
                }
                return null;
            }
        });
        if (input.open() == 0) {
            this.ignoreRegexps.add(input.getValue());
            this.ignoreRegexpViewer.refresh();
            this.getLaunchConfigurationDialog().updateButtons();
        }
    }

    void handleRemoveRegexp() {
        List ls = ((IStructuredSelection)this.ignoreRegexpViewer.getSelection()).toList();
        if (this.ignoreRegexps.removeAll(ls)) {
            this.ignoreRegexpViewer.refresh();
        }
    }

    void handleAddChecker() {
    }

    void handleRemoveChecker() {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("com.narucy.webpub.linkcheck.ignoreRegexp", (List)EMPTY_LIST);
        wc.setAttribute("com.narucy.webpub.linkcheck.checkSchemes", Arrays.asList(ORIGINAL_CHECKERS));
        wc.setAttribute("com.narucy.webpub.linkcheck.background", true);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            this.ignoreRegexps.clear();
            this.ignoreRegexps.addAll(conf.getAttribute("com.narucy.webpub.linkcheck.ignoreRegexp", (List)EMPTY_LIST));
            List schemes = conf.getAttribute("com.narucy.webpub.linkcheck.checkSchemes", Arrays.asList(ORIGINAL_CHECKERS));
            this.schemeViewer.setCheckedElements(schemes.toArray());
            this.backgroundButton.setSelection(conf.getAttribute("com.narucy.webpub.linkcheck.background", true));
        }
        catch (CoreException e) {
            WebpubDebugPlugin.handleException((Exception)((Object)e));
        }
        this.ignoreRegexpViewer.refresh();
        this.schemeViewer.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("com.narucy.webpub.linkcheck.ignoreRegexp", (List)this.ignoreRegexps);
        wc.setAttribute("com.narucy.webpub.linkcheck.checkSchemes", Arrays.asList(this.schemeViewer.getCheckedElements()));
        wc.setAttribute("com.narucy.webpub.linkcheck.background", this.backgroundButton.getSelection());
    }

    public String getName() {
        return "&Link Check";
    }

    public Image getImage() {
        return this.iconImage;
    }

    public void dispose() {
        if (this.iconImage != null) {
            this.iconImage.dispose();
        }
        super.dispose();
    }
}

