#
# $Id: abstract_page.rb,v 1.1 2004/01/17 12:02:34 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'amrita/node_expand'
require 'amrita/template'

class AbstractPage < Hash

	def initialize
		super()
	end

	def []=(key, value)
		key = key.intern if key.instance_of?(String)
		store(key, value)
	end

	def [](key)
		key = key.intern if key.instance_of?(String)
		return send(key) if key.instance_of?(Symbol) and respond_to?(key)
		return fetch(key) if key?(key)
		
		handle_error(key)
	end
	
	def handle_error(key)
		puts "key not found: #{key}"	
	end

	
end
