# $Id: generator.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'sitemapper/navigation'
require 'rexml/document'
require 'rexml/streamlistener'

module SiteMapper

class SitemapDecorator

	def initialize
		@count = 0
	end

	def indent
		'	' * @count
	end

	def begin_item
		indent + "<li>\n"
	end
	
	def end_item
		indent + "</li>\n"
	end

	def item( title, link)
		indent + %!<a href="#{link}">#{title}</a>\n!
	end

	def begin_list
		v = indent + "<ul>\n"
		@count+=1
		v
	end

	def end_list
		@count-=1
		indent + "</ul>\n"
	end

end

class SitemapGenerator

	def initialize(dir = nil)
		@decorator = SitemapDecorator.new
		@current_dir = dir
	end

	attr_accessor :decorator, :current_dir

	def expand_element( elem, stream)
		stream << @decorator.begin_list.to_s
		elem.each_element { |e|
			url = e.attributes['href']
			next unless url
			
			e.attributes['label'] = title = e.attributes['label']
			stream << @decorator.begin_item.to_s
			stream << @decorator.item( title, url).to_s
			expand_element(e, stream) if e.elements.size > 0
			stream << @decorator.end_item.to_s
		}
		stream << @decorator.end_list.to_s
	end

	def gen(filepath, root_href = nil)
		dir = File.expand_path(File.dirname(filepath)) unless @current_dir
		
		doc = REXML::Document.new( File.new(filepath) )
		root_elem = doc.root
		root_elem = find_elem(root_elem, root_href) if root_href
		
		raise ArgumentError, "not found href for root node" unless root_elem
		
		dist_stream = ''
		expand_element(root_elem, dist_stream)
		
		dist_stream
	end

	alias do_parse gen

	def find_elem(elem, root_href)
		elem.each_element { |e|
			return e if root_href == e.attributes['href']
			return e if e = find_elem(e, root_href)
		}
		nil
	end

end

end