#
# $Id: abstorel_filter_test.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'ftools'
require 'test/unit'
require 'webpub/publish_manager'
require 'webpub/rftools'

class AbsToRelFilterTest < Test::Unit::TestCase

	def setup
		@proj_location = 'test_resources/webproject002'
		@tmpdir = ENV['TEMP'] + '/amrita_publisher_test' + rand(999).to_s
		File.cp_all( @proj_location, @tmpdir)
	end

	def test_filter
		config = ENV['TEMP'] + '/pubprop'
		begin
			open(config, 'w') { |fh|
				dir = File.dirname(__FILE__)
				fh << [WebPub::PublishDescription::BY_COPY, "#{dir}/copy_publisher.rb", 'WebPub::CopyPublisher'].join(',') + "\n"
			}
			manager = WebPub::PublishManager.new(config)
			manager.publish( Dir.glob(@tmpdir + '/ht_sources/abstorel/*') )
		ensure
			File.delete config
		end
		
		ls = IO.readlines(@tmpdir + '/public_html/abstorel/a.html').join
		assert_not_nil( %r!"../a.html"! === ls )
		assert_not_nil( %r!"../c/c/c.html"! === ls )
		assert_not_nil( %r!"001/002/f.html"! === ls )

		assert_not_nil( %r!src="../a.gif"! === ls)
		assert_not_nil( %r!src="d.gif"! === ls)
		assert_not_nil( %r!src="001/002/f.gif"! === ls)
	end

	def teardown
		begin
			File.rm_all(@tmpdir)
		rescue
		end
	end

end
