#
# $Id: amrita_checker.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/install_checker'

module WebPub

class AmritaChecker < InstallChecker

	def check
		begin
			require 'amrita/template'
		rescue LoadError
			return 'Amrita is not installed', ERROR
		end
		
		dist = ''
		begin
			tmpl = Amrita::TemplateText.new('<a href="@r"></a>')
			if tmpl.respond_to?('expand_attr=')
				tmpl.expand_attr = true
			end
			tmpl.expand(dist, {:r => 'a.png'})
		rescue 
		end
		
		return 'Not supported expand attribute.', ERROR if '<a href="a.png"></a>' != dist
		
		nil
	end
end

end