#
# $Id: copy_publisher_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'ftools'
require 'test/unit'
require 'webpub/rftools'
require 'webpub/publisher'
require 'webpub/publish_manager'
require 'webpub/copy_publisher'

=begin

=end
class CopyPublisherTest < Test::Unit::TestCase

	def test_publish_by_copy
		proj_location = 'test_resources/webproject001'
		tmpdir = ENV['TEMP'] + '/copy_publisher_test'
		begin
			# prepare
			File.cp_all(proj_location, tmpdir)
	
			config = ENV['TEMP'] + '/pubprop'
			open(config, 'w') { |fh|
				fh << [WebPub::PublishDescription::BY_COPY, File.dirname(__FILE__) + '/copy_publisher.rb', 'WebPub::CopyPublisher'].join(',')
			}
			manager = WebPub::PublishManager.new(config)
			
			# first publish
			manager.publish( Dir.glob(tmpdir + '/ht_sources/folder4/*.png') )
			
			last_updates = {}
			Dir.glob(tmpdir + '/public_html/folder4/*') { |f|
				pf = tmpdir + '/ht_sources/folder4/' + File.basename(f)
				assert_equal(
					IO.readlines(pf),
					IO.readlines(f) )
				
				last_updates[pf] = File.mtime(pf)
			}
			
			# second publish
			open( tmpdir + '/public_html/folder4/a.png', 'w') { |fh|
				fh << 'dummy a-1'
			}
			open( tmpdir + '/public_html/folder4/c.png', 'w') { |fh|
				fh << 'dummy c-1'
			}
			
			manager.publish( Dir.glob(tmpdir + '/ht_sources/folder4/*.png') )
			Dir.glob(tmpdir + '/public_html/folder4/*') { |f|
				pf = tmpdir + '/ht_sources/folder4/' + File.basename(f)
				assert_equal(
					IO.readlines(pf),
					IO.readlines(f) )
				
				if File.basename(f) == 'b.png'
					last_updates[pf] == File.mtime(pf)
				else
					last_updates[pf] < File.mtime(pf)
				end
			}
		ensure
			File.delete config
			File.rm_all(tmpdir)
		end
	end


end