#
# $Id: rd_publisher.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/publisher'
require 'cgi'
require 'rd/rd2html-lib'
require 'rd/rdfmt'

=begin

= WebPub::RDPublisher

RDPublisher provides to generate html document from specify rd file.

=end

module WebPub

class RDPublisher < Publisher

	def rd_to_html(src)
		visitor = $Visitor_Class.new
		
		tree = RD::RDTree.new(src, [], nil)
		tree.parse
		visitor.visit(tree)
	end

	def publish(desc)
		begin
			lines = rd_to_html(IO.readlines(desc.publish_from).join('') )
			open(desc.publish_to, 'w') { |fh|
				fh << lines
			}
		rescue Exception
			open(desc.publish_to, 'w') { |fh|
				fh << "<body><h4>#{CGI.escapeHTML($!.message)}</h4>"
				fh << %Q!<pre>#{CGI.escapeHTML($!.backtrace.join("\n"))}</pre>!
				fh << '</body>'
			}
			raise $!.class, $!.message, $!.backtrace
		end
	end
end

end