#
# $Id: checkers.rb,v 1.1 2004/01/10 07:37:28 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#
require 'net/ftp'
require 'net/http'

module LinkChecker

class FileChecker

	def check(uri, base_file)
		path = uri.path
		path = File.join(File.dirname(base_file), path) unless /^\// === path
		
		File.exist?(path) ? nil : "file not found: #{path}"
	end
end

class HTTPChecker

	def initialize(error_codes = [404, 500, 501, 502, 503, 504, 505])
		@error_codes = error_codes
	end
	
	attr_reader :error_codes

	def check(uri)
		begin
			h = create_connection(uri)
			h.start
			res =  h.head(uri.request_uri)
			return @error_codes.include?(res.code.to_i) ?
				"HTTP bad response:#{res.code}:#{res.message}" : nil
		rescue
			return "#{$!.backtrace[0]}:#{$!.message}"
		ensure
			h.finish if h and h.active?
		end
		
		nil
	end
	
	def create_connection(uri)
		Net::HTTP.new(uri.host, uri.port)
	end

end

class FTPChecker

	def check(uri)
		begin
			conn = Net::FTP.open(uri.host)
			conn.login
			ls = conn.nlst(File.dirname(uri.path))
			if !uri.path.empty? and !ls.include?(uri.path)
				return "file not found in ftp server directory: #{uri.path}"
			end
			return nil
		rescue
			return $!.message
		ensure
			conn.close if conn
		end
	end

end

end