#!/usr/bin/perl
###
require "package/ReadConfig.pl";
require "package/PrintRedirect.pl";
require "package/HtmlDelete.pl";
require "package/CheckPermission.pl";
###
&MultipartForm;
$FILE=$Data{'FILE'};
die('error') if($FILE=~/\// || $FILE=~/^\./);
die('error') if($Filename{'UPLOAD'}=~/\// || $Filename{'UPLOAD'}=~/^\./);
$THEME=$Data{'THEME'} || $CONFIG{'DefaultTheme'} || 'default';
###
&UploadFile;
&PrintRedirect::ExitScript("html/$THEME/$FILE.html");
###
sub UploadFile{
	&PrintRedirect::ExitScript("html/$THEME/$FILE.e1.html") if(!&CheckPermission::write);
	&PrintRedirect::ExitScript("html/$THEME/$FILE.e2.html") if(!$Filename{'UPLOAD'} || substr($Filename{'UPLOAD'},0,1) eq '.');
	&PrintRedirect::ExitScript("html/$THEME/$FILE.e3.html") if(-e("file/$Filename{'UPLOAD'}"));
	open(FILE,"+>file/$Filename{'UPLOAD'}");
	print FILE $Data{'UPLOAD'};
	close(FILE);
	&HtmlDelete::delete;
}
###
sub MultipartForm{
	my($form,$separate,@form,$head,$data,$name,$filename,@head,@line);
	read(STDIN,$form,$ENV{'CONTENT_LENGTH'});
	$form=~/^([^\r\n]+)[\r\n]/;
	$separate=$1;
	@form=split(/$separate../s,$form);
	foreach $data(@form){
		substr($data,-2,2,'');
		($head,$data)=split(/\r\n\r\n/,$data,2);
		$name="";
		$filename="";
		@head=split(/[\r\n]/,$head);
		foreach(@head){
			next if(!/^Content-Disposition:/);
			@line=split(/; */);
			foreach(@line){
				if(/^name="([^"]+)"/){
					$name=$1;
					next;
				}
				if(/^filename="([^"]+)"/){
					$filename=$1;
					$filename=$1 if($filename=~/\\([^\\]+)$/);
					next;
				}
			}
			$Data{$name}=$data;
			$Filename{$name}=$filename;
			last;
		}
	}
}
###

