//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDWINDOWDEV_H
#define WSDWINDOWDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>

class WSDwindowDev :public WSDdev{

 protected:
  WSClistData _event_clients;
  short     _exposed_x;
  short     _exposed_y;
  WSCushort _exposed_w;
  WSCushort _exposed_h;
  short     _pix_draw_x;
  short     _pix_draw_y;
  WSCushort _pix_draw_w;
  WSCushort _pix_draw_h;
  short     _w_x;
  short     _w_y;
  WSCushort _w_w;
  WSCushort _w_h;
  short     _bg_no;
  short     _bp_no;
  short     _diff_x;
  short     _diff_y;
  WSCushort _mouse_no;
  unsigned _expose_sequence:1;
  unsigned _pixmap_created:1;
 private:
  unsigned _event_delivering_sequence:1;
  unsigned _client_deleted:1;
  unsigned _pixmap_style:2;
 protected:
  void setExposedArea(short,short,WSCushort,WSCushort);
  void setPixmapStyle(char);
  virtual long createWindow();
  virtual long createPixmap();
  virtual long createContext();

  virtual long destroyWindow();
  virtual long destroyPixmap();
  virtual long destroyContext();

  virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
  virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
  virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);
public:
  virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);
protected:
  virtual long clearArea(long x,long y,WSCulong w,WSCulong h,WSCbool fl,WSCbool scaling = True);
  virtual void exposeExecute(short x,short y,WSCushort w,WSCushort h);

  void setBackColorNo(short);

 public:
  WSDwindowDev();

  void getWindowSize(short* x,short* y,WSCushort* w,WSCushort* h);
  void onMouseIn(WSCpoint*);
  void onMouseOut();
  void onMouseMove(WSCpoint*);
  void onMousePress(WSCpoint*);
  void onMouseDoubleClick(WSCpoint*);
  void onMouseRelease(WSCpoint*);
  void onResize(WSCrect*);
  void onExpose(WSCrect*);
  void onUnmap();
  void onFocusChange();

  char getPixmapStyle();
  void     setExposeSequence(WSCbool);
  WSCbool  getExposeSequence();

  virtual long setEventOrder(WSDdev*,char top_or_bottom);
  virtual long setEvent(WSDdev*,WSCbool on_off);
  virtual long execEvent(long ev_kind,void* data);
  virtual long cancelEvent(WSDdev* dev);

  virtual long    initialize();
  virtual long    getAvailableEventBit();
  virtual WSCbool isAvailableEvent(long ev_kind);
  virtual long    setEnableEvent(long ev_kind);
  virtual long    setEnableEventBit(long ev_bit);
  virtual long    setDisableEvent(long ev_kind);
  virtual void    getDispAddr(short*,short*);

  virtual long    beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,WSCbool scaling = True);
  virtual long    endDraw();
  virtual long    getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling = True);
  virtual WSCbool isExposed(short x,short y,WSCushort w,WSCushort h,WSCbool scaling = True);
  virtual long  setValue(long kind,void* data);
  virtual long  getValue(long kind, void* value);
  virtual long  detachClient();
  virtual WSCbool getReady();
  virtual long copyArea(long,long,WSCulong,WSCulong,long,long);

  WSCbool getAbsoluteDraw();
  short getBackColorNo();

  WSCushort getWidth();
  WSCushort getHeight();

  virtual long raise();
  virtual long lower();

//  static void* setGlobalMouseInHandler( void(*)(WSDdev*) );
//  static void* setGlobalMousePressHandler( void(*)(WSDdev*) );
//  static void* setGlobalMouseReleaseHandler( void(*)(WSDdev*) );
  WSMFclassDef(WSDwindowDev,WSDdev);
};
#define WS_WINDOW_TO_WINDOW  0
#define WS_PIXMAP_TO_WINDOW  1
#endif
