/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  object3d.cpp  11/22/97                                                 */
/*  Copyright (C) 1995 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include  "object3d.h"

TObject3D::TObject3D(int vn, int pn) : Polygon(vn, pn)
{
}

TObject3D::~TObject3D()
{
}

void TObject3D::show(TObject3D *eye)
{

      int n = Polygon.Vertex.GetCount();
#ifdef WS
	  int i;
      for(i=0; i<n; i++) {
#else //WS
      for (int i=0; i<n; i++) {
#endif //WS
          Vector v = ConvCoordinate(Axis.get_matrix(), Polygon.Vertex.vert[i]->local);
          Polygon.Vertex.vert[i]->world = v + Axis.get_origin();
      }
#ifdef WS
      for (i=0; i<n; i++) {
#else //WS
      for (int i=0; i<n; i++) {
#endif //WS
          Vector v = Polygon.Vertex.vert[i]->world - eye->Axis.get_origin();
          Polygon.Vertex.vert[i]->eye = ConvCoordinate2(eye->Axis.get_matrix(), v);
      }
}

