//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <mac/WSDmacNwDev.h>
#include <mac/WSDmacFormDev.h>
#include <mac/WSDmacAppDev.h>
#include <mac/WSDmacDraw.h>
#include <mac/WSmcom.h>

#include <WSCdevice.h>
#include <WSCbase.h>

WSMFclassInit(WSDmacNwDev,WSDnwDev);

WSDdev* _wsdmacNwdev_init_(){
//WSMFtrace("create WSDmacNwDev \n");
  return new WSDmacNwDev();
}

class _WSDmacNwDev_init_ {
  public:_WSDmacNwDev_init_(){
//WSMFtrace("set create handler of WSDmacNwDev \n");
     WSGIappDevice()->setCreateHandler("nwDev",_wsdmacNwdev_init_);
  };
};
static _WSDmacNwDev_init_ _init_to_run_WSDmacNwDev_;

//static WSDxdraw* draw_of_macNw = NULL;

WSDmacNwDev::WSDmacNwDev(){
//WSMFtrace("WSDmacNwDev::WSDmacNwDev 0x%x 0x%x\n",this,*(long*)this);
//  if (draw_of_macNw == NULL){
//    draw_of_macNw = new WSDxdraw();
//  }
//  setDraw(draw_of_macNw);
}

WSDmacNwDev::~WSDmacNwDev(){
}

//Pixmap WSDmacNwDev::_pixmap = 0;
//GC     WSDmacNwDev::_gc = 0;
#if 0 //XXZZ
long WSDmacNwDev::getPixmap(){
    WSCushort w1 = _w;    
    WSCushort h1 = _h;    
    if (w1 > 4096){
      w1 = 4096;
    }
    if (h1 > 4096){
      h1 = 4096;
    }
    if (_pixmap_w < w1 || _pixmap_h < h1){
      if (_pixmap_w < w1){
        _pixmap_w = w1;
      }
      if (_pixmap_h < h1){
        _pixmap_h = h1;
      }
      if (_pixmap != 0){
        WSGFxReleasePixmap(_pixmap);
        _pixmap = 0;
      }
    }
  
    if (_pixmap == 0){
      Display* dpy = (Display*)getDeviceResource();
      WSDxappDev* app   = WSGIxwinAppDev();
      if (_pixmap_w == 0){
        _pixmap_w = 100;
      }
      if (_pixmap_h == 0){
        _pixmap_h = 100;
      }
      _pixmap = WSGFxGetPixmap(_pixmap_w,_pixmap_h);
      if (_gc == 0){
        _gc = app->appGC();
      }
      XFillRectangle(dpy,_pixmap,_gc,0,0,_pixmap_w,_pixmap_h);
    }

    //fault
    if (_pixmap == 0){
WSMFtrace("Error!   WSDmacNwDev::getPixmap cannot create pixmap.\n");
WSMFtrace("terminate application.\n");
      exit(1);
    }
    return (long)_pixmap;
}
#endif //XXZZ

long WSDmacNwDev::_copy_pixmap_to_window(){
#if 0 //XXXZZ
  if (_pixmap  !=0){
    Display* dpy = (Display*)getDeviceResource();
    Window   win = (Window)WSDnwDev::getWindowResource();
    XCopyArea(dpy,_pixmap,win,_gc,_copy_pixmap_x,_copy_pixmap_y,_copy_pixmap_w,_copy_pixmap_h,
                _back_x + _copy_pixmap_x,_back_y + _copy_pixmap_y);
  }
#endif //XXZZ
printf("WSDmacNwDev::_copy_pixmap_to_window not implemented.. \n");
  return WS_NO_ERR;
}
long WSDmacNwDev::getWindowResource(){
  WSDdev* parent = getParentDev();
  if (parent == NULL){
    return -1;
  }
#if 0 //XXZZ
  if (getUsePixmap() != False){
    long ret = parent->getWindowResource();
    if (ret != -1){
      return getPixmap();
    }else{
      return -1;
    }
  }
#endif //XXZZ
  return parent->getWindowResource(); 
}
long WSDmacNwDev::setValue(long kind,void* data){
  switch(kind){
    case WSDEV_USE_PIXMAP:
      setUsePixmap(False);
      return WS_NO_ERR;
  }
  return WSDnwDev::setValue(kind,data);
}
long WSDmacNwDev::beginDraw(short x,short y,WSCushort w,WSCushort h,       
                         WSCbool absolute,WSCbool scaling){

  long ret = WSDnwDev::beginDraw(x,y,w,h,absolute,scaling);
  long px = 0,py = 0;
  WSCulong pw = 0x7fff,ph = 0x7fff;
  long cx,cy;
  WSCulong cw,ch;
  WSDdev* pdev = getParentDev();
  if (pdev != NULL){
    WSDmacFormDev* fdev =(WSDmacFormDev*)pdev->cast("WSDmacFormDev");
    if (fdev != NULL){
//XXZZXXZZ
      long vx,vy,vw,vh;
      fdev->getGeometry(&vx,&vy,&vw,&vh);
      fdev->getVaridArea(&px,&py,&pw,&ph);
      px = px - vx;
      py = py - vy;
    }
  }
  WSGFandArea(_x,_y,_w,_h,px,py,pw,ph,&cx,&cy,&cw,&ch);
  setRegion(cx - _x,cy - _y,cw,ch);
  return ret;
}

