//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCRpulldownMenu.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCpulldownMenu.h>

WSMFclassInit(WSCRpulldownMenu,WSCRvlabel);
WSMFremoteClassInit(WSCRpulldownMenu,WSCpulldownMenu);

WSCRpulldownMenu::WSCRpulldownMenu(){
}

WSCRpulldownMenu::~WSCRpulldownMenu(){
}

void WSCRpulldownMenu::onActivate(){
  if (_local != NULL){
    WSCpulldownMenu* item = (WSCpulldownMenu*)_local->cast("WSCpulldownMenu");
    if (item != NULL){
      item->onActivate();
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCpulldownMenu");
  rc.setOperationName("onActivate");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  endRemoteCall();
}

long WSCRpulldownMenu::getValue(){
  if (_local != NULL){
    WSCpulldownMenu* item = (WSCpulldownMenu*)_local->cast("WSCpulldownMenu");
    if (item != NULL){
      return item->getValue();
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCpulldownMenu");
  rc.setOperationName("getValue");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  } 
  long ret = 0;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRpulldownMenu::getItems(){
  if (_local != NULL){
    WSCpulldownMenu* item = (WSCpulldownMenu*)_local->cast("WSCpulldownMenu");
    if (item != NULL){
      return item->getItems();
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCpulldownMenu");
  rc.setOperationName("getItems");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  } 
  long ret = 0;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRpulldownMenu::setItemSensitive(short no,WSCbool fl){
  if (_local != NULL){
    WSCpulldownMenu* item = (WSCpulldownMenu*)_local->cast("WSCpulldownMenu");
    if (item != NULL){
      return item->setItemSensitive(no,fl);
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCpulldownMenu");
  rc.setOperationName("setItemSensitive");
  beginRemoteCall(&rc);
  _db->save(WS_DcRShort,"no",(void*)&no);
  _db->save(WS_DcRChar,"fl",(void*)&fl);

  if (_db == NULL){
    return 0;
  } 
  long ret = 0;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRpulldownMenu::setValueSensitive(short id,WSCbool fl){
  if (_local != NULL){
    WSCpulldownMenu* item = (WSCpulldownMenu*)_local->cast("WSCpulldownMenu");
    if (item != NULL){
      return item->setValueSensitive(id,fl);
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCpulldownMenu");
  rc.setOperationName("setValueSensitive");
  beginRemoteCall(&rc);
  _db->save(WS_DcRShort,"id",(void*)&id);
  _db->save(WS_DcRChar,"fl",(void*)&fl);

  if (_db == NULL){
    return 0;
  } 
  long ret = 0;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}






void _WSCpulldownMenu_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCpulldownMenu* item = (WSCpulldownMenu*)inst->cast("WSCpulldownMenu");
        long ret = 0;
        if (item != NULL){
          ret = item->getValue();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"getItems")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCpulldownMenu* item = (WSCpulldownMenu*)inst->cast("WSCpulldownMenu");
        long ret = 0;
        if (item != NULL){
          ret = item->getItems();
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }

  }else
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onActivate")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCpulldownMenu* item = (WSCpulldownMenu*)inst->cast("WSCpulldownMenu");
        if (item != NULL){
          item->onActivate();
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 's'){
    if (!strcmp(rc->_op,"setItemSensitive")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCpulldownMenu* item = (WSCpulldownMenu*)inst->cast("WSCpulldownMenu");
        long ret = 0;
        if (item != NULL){
          short no;
          db->load(WS_DcRShort,"no",(void*)&no);
          WSCbool fl;
          db->load(WS_DcRChar,"fl",(void*)&fl);
          ret = item->setItemSensitive(no,fl);
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }else
    if (!strcmp(rc->_op,"setValueSensitive")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCpulldownMenu* item = (WSCpulldownMenu*)inst->cast("WSCpulldownMenu");
        long ret = 0;
        if (item != NULL){
          short id;
          db->load(WS_DcRShort,"id",(void*)&id);
          WSCbool fl;
          db->load(WS_DcRChar,"fl",(void*)&fl);
          ret = item->setValueSensitive(id,fl);
        }
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }else{
        long ret = 0;
        db->save(WS_DcRLong,"ret",(void*)&ret);
      }
      return;
    }

  }
extern void _WSCvlabel_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCvlabel_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCpulldownMenu,_WSCpulldownMenu_remote_call);

