//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <x11/WSDxnwDev.h>
#include <x11/WSDxappDev.h>
#include <x11/WSDxdraw.h>
#include <x11/WSxcom.h>
#include <WSCdevice.h>
#include <WSCbase.h>

WSMFclassInit(WSDxnwDev,WSDnwDev);

WSDdev* _wsdxnwdev_init_(){
//WSMFtrace("create WSDxnwDev \n");
  return new WSDxnwDev();
}

class _WSDxnwDev_init_ {
  public:_WSDxnwDev_init_(){
//WSMFtrace("set create handler of WSDxnwDev \n");
     WSGIappDevice()->setCreateHandler("nwDev",_wsdxnwdev_init_);
  };
};
static _WSDxnwDev_init_ _init_to_run_WSDxnwDev_;

//static WSDxdraw* draw_of_xnw = NULL;

WSDxnwDev::WSDxnwDev(){
//WSMFtrace("WSDxnwDev::WSDxnwDev 0x%x 0x%x\n",this,*(long*)this);
//  if (draw_of_xnw == NULL){
//    draw_of_xnw = new WSDxdraw();
//  }
//  setDraw(draw_of_xnw);
}

WSDxnwDev::~WSDxnwDev(){
}

Pixmap WSDxnwDev::_pixmap = 0;
GC     WSDxnwDev::_gc = 0;

long WSDxnwDev::getPixmap(){
    WSCushort w1 = _w;    
    WSCushort h1 = _h;    
    if (w1 > 4096){
      w1 = 4096;
    }
    if (h1 > 4096){
      h1 = 4096;
    }
    if (_pixmap_w < w1 || _pixmap_h < h1){
      if (_pixmap_w < w1){
        _pixmap_w = w1;
      }
      if (_pixmap_h < h1){
        _pixmap_h = h1;
      }
      if (_pixmap != 0){
        WSGFxReleasePixmap(_pixmap);
        _pixmap = 0;
      }
    }
  
    if (_pixmap == 0){
      Display* dpy = (Display*)getDeviceResource();
      WSDxappDev* app   = WSGIxwinAppDev();
      if (_pixmap_w == 0){
        _pixmap_w = 100;
      }
      if (_pixmap_h == 0){
        _pixmap_h = 100;
      }
      _pixmap = WSGFxGetPixmap(_pixmap_w,_pixmap_h);
      if (_gc == 0){
        _gc = app->appGC();
      }
      XFillRectangle(dpy,_pixmap,_gc,0,0,_pixmap_w,_pixmap_h);
    }

    //fault
    if (_pixmap == 0){
WSMFtrace("Error!   WSDxnwDev::getPixmap cannot create pixmap.\n");
WSMFtrace("terminate application.\n");
      exit(1);
    }
    return (long)_pixmap;
}


long WSDxnwDev::_copy_pixmap_to_window(){
  if (_pixmap  !=0){
    Display* dpy = (Display*)getDeviceResource();
    Window   win = (Window)WSDnwDev::getWindowResource();
    XCopyArea(dpy,_pixmap,win,_gc,_copy_pixmap_x,_copy_pixmap_y,_copy_pixmap_w,_copy_pixmap_h,
                _back_x + _copy_pixmap_x,_back_y + _copy_pixmap_y);
  }
  return WS_NO_ERR;
}
long WSDxnwDev::getWindowResource(){
  WSDdev* parent = getParentDev();
  if (parent == NULL){
    return -1;
  }
  if (getUsePixmap() != False){
    long ret = parent->getWindowResource();
    if (ret != -1){
      return getPixmap();
    }else{
      return -1;
    }
  }
  return parent->getWindowResource(); 
}

