//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCRLIST_H
#define WSCRLIST_H

#include <WScom.h>
#include <WSCRscrForm.h>
#include <WSCstring.h>
#include <WSDserialize.h>
#include <WSCconductor.h>

class WSCRlist :public WSCRscrForm{

 protected:
 public:
  WSCRlist();
  virtual ~WSCRlist();

  void onSort();
  void onItemSelected();

  void setLabelHeight(WSCushort h);
  void delAll();
  long getNum();
  WSCstring getItem(long pos);
  void addItem(char* item,long pos = -1); 
  void replaceItem(char* item,long pos);
  void replaceItem(char* item,long pos,long column);
  void delPos(long pos);
  long getSelectedPos();
  long setSelectPos(long);
  WSCstring getSelectedItem();
  void setTopPos(long);
  void setBottomPos(long);
  long getTopPos();
  long getBottomPos();
  void updateList();

  WSCbool   getSelectItemChanged();
  void      setSelectItemChanged(WSCbool);
  void      setEnableActivate(WSCbool);
  WSCbool   getEnableActivate();
  void      setAbsoluteChangeSelectFlag(WSCbool);
  WSCbool   getAbsoluteChangeSelectFlag();

  long      setItemVisible(long pos,WSCbool fl);

  long      setItemValue(long pos,long kind,long val);
  long      getItemValue(long pos,long kind,long* val);

  WSMFclassDef(WSCRlist,WSCRscrForm);
};
#endif
