//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCCONDUCTOR_H
#define WSCCONDUCTOR_H
#include <WSdrDef.h>
#include <WSCtypeServer.h>
#include <WSClistData.h>
#include <WSCindexData.h>

class WSDserialize;
class WSDsocket;

struct WSCremoteCall{
  WSCushort _port;
  WSCstring _addr;
  char* _class;
  char* _instance;
  char* _op;
  WSCstring _dest_addr;
  void setOperationName(char* opname);
  void setClassName(char* cname);
  void setInstanceName(char* cname);
  WSCremoteCall();
  ~WSCremoteCall();
};


class WSCconductor{

 protected:
  WSClistData   _serialize_list;
  WSClistData   _type_server_list;
  WSCstring     _serialize_path;
  WSCstring _addr;
  WSCushort _port;
  WSDsocket* _sock;
  WSDsocket* _csock;
  WSCulong _timeout;
  WSCbool _accepted;
  WSCbool _need_update;
  WSCindexData   _net_server_handler_list;
  long _timer_id;
  long _timer_cnt;

  static void _timer_work(WSCuchar,void*);
  static void _accepted_work(WSDsocket* sock,void* socket,WSCulong addr);

 public:
  WSCconductor();
  virtual ~WSCconductor();

  WSCtypeServer* searchTypeServer(char*);
  char* getSerializePath();
  void  setSerializePath(char*);

  long add(WSCtypeServer*);
  long addSerialize(WSDserialize* );
  long del(WSCtypeServer*);
  WSDserialize*   getSerialize(char* serialize_type);
  WSDserialize*   getNewSerialize(char* serialize_type);

  long  save(WSDserialize*, char* type, char* nm, void* ptr);        
  long  load(WSDserialize*, char* type, char* nm, void* ptr);   
  long  loadAlloc(WSDserialize*,char* type,char* nm,void** ptr,void* cdata); 

  WSDserialize* beginTransaction(char* stype,char* sname,WSDserialize*);
  WSDserialize* beginTransaction(char* stype,char* sname);
  long         endTransaction(WSDserialize*);

  long  saveGUI(WSDserialize*,char* name,WSCbase*);
  long  loadGUI(WSDserialize*,WSCbase**,WSCbase*);

  void setPort(WSCushort port);
  WSCushort getPort();

  void setAddr(char* addr);
  WSCstring getAddr();

  void setTimeout(WSCulong t);
  long startDispatch();
  long stopDispatch();

  WSDserialize* beginRemoteCall(WSCremoteCall*);
  long endRemoteCall(WSDserialize*);

  void addNetServerHandler(char* cname,void* handler);

  void clearUpdateCounter();
};
extern WSDLEX WSCconductor* WSGIconductor();

class WSCbinType{

protected:
  WSCbool _need_swap;
public:
  WSCbinType();
  void memcpy2b(char* dest,short src);
  void memcpy4b(char* dest,long src);
  void memcpy8b(char* dest,void* src);
  void memcpy16b(char* dest,void* src);
  void memcpy32b(char* dest,void* src);
  void memscan2b(short* src,char* dest);
  void memscan4b(long* src, char* dest);
  void memscan8b(void* src, char* dest);
  void memscan16b(void* src,char* dest);
  void memscan32b(void* src,char* dest);
};

extern WSDLEX WSCbinType*   WSGIbinType();

#define WSMFdefineDrNetServer(CTYPE,FN) \
class CTYPE ## _dr_net_server { \
  public: \
  CTYPE ## _dr_net_server() { \
    WSGIconductor()->addNetServerHandler( #CTYPE, (void*)FN); \
  }; \
}; \
CTYPE ## _dr_net_server _exec_ ##  CTYPE ## _dr_net_server;

#endif
