#ifndef WSCDB_H
#define WSCDB_H

#define FACTORY_METHOD			// factory method handler use

#include <WScom.h>
#include <WSCvariant.h>
#include <WSCstring.h>
#include <WSCindexData.h>

/* SQL_CONCURRENCY options */
#define WSCDB_SQL_CONCUR_READ_ONLY            1
#define WSCDB_SQL_CONCUR_LOCK                 2
#define WSCDB_SQL_CONCUR_ROWVER               3
#define WSCDB_SQL_CONCUR_VALUES               4
#define WSCDB_SQL_CONCUR_DEFAULT              WSCDB_SQL_CONCUR_READ_ONLY

/* SQL_CURSOR_TYPE options */
#define WSCDB_SQL_CURSOR_FORWARD_ONLY         0UL
#define WSCDB_SQL_CURSOR_KEYSET_DRIVEN        1UL
#define WSCDB_SQL_CURSOR_DYNAMIC              2UL
#define WSCDB_SQL_CURSOR_STATIC               3UL
#define WSCDB_SQL_CURSOR_TYPE_DEFAULT         WSCDB_SQL_CURSOR_FORWARD_ONLY

// FIELD TYPE
#define WSCDB_FIELD_TYPE_CHAR                 1
#define WSCDB_FIELD_TYPE_NUMERIC              2
#define WSCDB_FIELD_TYPE_DECIMAL              3
#define WSCDB_FIELD_TYPE_INTEGER              4
#define WSCDB_FIELD_TYPE_SMALLINT             5
#define WSCDB_FIELD_TYPE_FLOAT                6
#define WSCDB_FIELD_TYPE_REAL                 7
#define WSCDB_FIELD_TYPE_DOUBLE               8
#define WSCDB_FIELD_TYPE_DATE                 9
#define WSCDB_FIELD_TYPE_TIME                 10
#define WSCDB_FIELD_TYPE_TIMESTAMP            11
#define WSCDB_FIELD_TYPE_NONE                 99

class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCdbRecord;
class WSCvdb;

class WSCdbDatabase
{
protected:
	static WSCindexData* _factory_list;
        char* _err_msg;
public:
	WSCdbDatabase();
	virtual ~WSCdbDatabase();

#ifdef FACTORY_METHOD
	static	void setCreateHandler(void* hd,char* drvame);
#endif

	virtual long WSCdbDatabase::setDatabase(const char* drvName);
	virtual long    open(char* host, char* uid, char* pwd, char* dbname = NULL, char* port = NULL);
	virtual long    close();
	virtual long    beginTran();
	virtual long    commitTran();
	virtual long    abortTran();
	virtual long    sqlExecute(const char* stmt);
	virtual WSCbool isOpen();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual void    getErrorMsg(char* szMsg,long size);
	virtual void    setEncode(long code);
	virtual long    getEncode();
	
	        char*   getDriverName();
	        void    addRecord(WSCdbRecord* pDb);
	        void    removeRecord(WSCdbRecord* pDb);

public:
	WSCdbDrvDatabase*	_db;
	char				_driver[80];
	WSCulong*			_rs;
	int					_rscount;
};

class WSCdbRecord
{
protected:
	static WSCindexData* _record_factory_list;
public:
	WSCdbRecord(WSCdbDatabase* pDatabase);
	WSCdbRecord(WSCvdb* inst);
	virtual ~WSCdbRecord();

#ifdef FACTORY_METHOD
	static	void setCreateHandler(void* hd,char* drvame);
#endif

	virtual long    open(const char* stmt);
	virtual long    open(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
	virtual long    close();
	virtual WSCbool isEOF();
	virtual WSCbool isOpen();
	virtual long    getColValue(long index, WSCvariant* var);
	virtual long    getColValue(const char* name, WSCvariant* var);
	virtual long    getColStringValue(long index, char* var);
	virtual long    getColStringValue(const char* name, char* var);
	virtual long    setColValue(long index, WSCvariant var);
	virtual long    setColValue(const char* name, WSCvariant var);
	virtual long    edit();
	virtual long    update();
	virtual long    addnew();
	virtual long    deleterow();
	virtual long    moveNext();
	virtual long    movePrevious();
	virtual long    moveFirst();
	virtual long    moveLast();
	virtual long    getColName(long index, char* name);
	virtual long    getColIndex(const char* name);
	virtual long    getColType(long index);
	virtual long    getColType(const char* name);
	virtual long    getColLength(long index);
	virtual long    getColLength(const char* name);
	virtual long    getRowCount();
	virtual long    getColCount();
	virtual void    getErrorMsg(char* szState, char* szMsg);
	virtual WSCstring getErrorMessage();

private:
	void Cleanup(WSCdbDatabase* pDatabase);

public:
	WSCdbDatabase*	_pDB;
	WSCdbDrvRecord*	_rs;
};

#endif		// WSCDB_H
