//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCPOPUPFRAME_H
#define WSCPOPUPFRAME_H
#include <WScom.h>
#include <WSCwindow.h>

class WSCpopupFrame    :public WSCwindow{

  protected:
    char*     _menu_str;
    WSCbool*  _status_array;
    long      _value;
    WSCushort _item_height;
    unsigned  _emboss:1;
    unsigned  _value_effective:1;
    unsigned  _font:4;

    WSMFpropertyDef( WSNfont,           WSCuchar, _font       );
    WSMFpropertyDef( WSNmenuItems,      char*,    _menu_str); 
    //menustring = string:value:op name,
    //             string:value:op name,.....
    WSMFpropertyDef( WSNmenuItemHeight, WSCushort,_item_height); 

    virtual long _device_initialize();
static void      (*_ext_draw_proc)(void*);
static WSCstring _policy_name;

  public:
    WSCpopupFrame(WSCbase*,char*);
    virtual ~WSCpopupFrame();

    virtual long initialize();
    virtual long draw();

    virtual void onVisibleChange(WSCbool);
    virtual void onResize(WSCrect*);
    virtual void onGuiPolicyChange(long);

    long    setItemSensitive(short no, WSCbool flag);
    void    setEmboss(WSCbool);

    WSCbool getValue(long* value);
    WSCbool getEmboss();

     //internal function
    void set_value_effective(WSCbool);
    void set_value(long v);

    WSMFguiClassDef(WSCpopupFrame,WSCwindow);
};

struct WSCpopupFrame_draw_struct{
  WSCpopupFrame* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
  short gradation;
  short gradation_margin;

  char*     menu_str;
  WSCbool*  status_array;
  WSCushort item_height;
  WSCbool   emboss;
  WSCuchar  font;

};


#endif
