//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCPRFORM_H
#define WSCPRFORM_H

#include <WScom.h>
#include <WSCform.h>
#include <WSDprDev.h>

#define WSCprform_VER  1000

class WSCprform   :public WSCform{

  protected:
    WSDprDev* _pr_dev;
    char* _file_name;
    short _w_x;
    short _w_y;
    WSCushort _w_w;
    WSCushort _w_h;
    unsigned  _format:4;
    unsigned  _type:2;
    unsigned  _orientation:1;

    WSMFpropertyDef(WSNfileName,   char*, _file_name );
    WSMFpropertyDef(WSNformat,   WSCuchar, _format );
    WSMFpropertyDef(WSNtype,   WSCuchar, _type );
    WSMFpropertyDef(WSNorientation,   WSCuchar, _orientation );
    WSMFpropertyDef(WSNworkX,   short, _w_x );
    WSMFpropertyDef(WSNworkY,   short, _w_y );
    WSMFpropertyDef(WSNworkWidth,   WSCushort, _w_w );
    WSMFpropertyDef(WSNworkHeight,   WSCushort, _w_h );

  public:
    WSCprform(WSCbase*,char*);
    virtual ~WSCprform();

    virtual long prdraw();
    virtual long draw();

    WSMFguiClassDef(WSCprform,WSCform);
    WSMFversionDef(WSCprform);
};

#endif
