//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVBTN_H
#define WSCVBTN_H

#include <WScom.h>
#include <WSCvlabel.h>
class WSDkeyboard;
class WSDmwindowDev;
#define WSCvbtn_VER  1000

class WSCvbtn   :public WSCvlabel{

  protected:
    char*     _td_name;
    char*     _bd_name;
    char*     _ld_name;
    char*     _rd_name;
    char*     _tb_name;
    char*     _btb_name;
    WSDmwindowDev** _mask_images;
    short     _push_pixmap;
    unsigned  _ef_move:1;
    unsigned  _press_state:1;
    unsigned  _focus_border:1;
    unsigned  _mouse_in:1;
    unsigned  _no_background:1;

    WSMFpropertyDef(WSNpushPixmap,      short,   _push_pixmap);
    WSMFpropertyDef(WSNenableFocusMove, WSCbool, _ef_move);
    WSMFpropertyDef(WSNupward,    char*, _td_name);
    WSMFpropertyDef(WSNdownward,  char*, _bd_name);
    WSMFpropertyDef(WSNleftward,  char*, _ld_name);
    WSMFpropertyDef(WSNrightward, char*, _rd_name);
    WSMFpropertyDef(WSNtab, char*, _tb_name);
    WSMFpropertyDef(WSNbacktab, char*, _btb_name);

    static WSCbool _special_key_handler(void*,WSDkeyboard*,WSCbool);
    static void _key_handler(void*,WSDkeyboard*,WSCbool);


    virtual long _device_initialize();

static void      (*_ext_draw_proc)(void*);
static WSCstring _policy_name;

  public:
    WSCvbtn(WSCbase* base, char* name);
    virtual ~WSCvbtn();

    virtual void onMousePress(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onMouseOut();
    virtual void onMouseIn(WSCpoint*);
    virtual void onVisibleChange(WSCbool);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onActivate();
    virtual void onKey(WSDkeyboard*,WSCbool);
    virtual void onFocusChange(WSCbool);
    virtual void onSpecialFocusChange(WSCbool);
    virtual void onGuiPolicyChange(long);

    virtual long addProcedure(WSCprocedure*);
//    virtual long execEventProc(long,void*);
    virtual long draw();
    void setDrawFocusBorder(WSCbool);
    void setNoBackground(WSCbool);

    WSMFguiClassDef(WSCvbtn,WSCvlabel);
    WSMFversionDef(WSCvbtn);
};

struct WSCvbtn_draw_struct{
  WSCvbtn* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  long blinking;
  long blink_fore;
  long shadow_type;
  long blink_type;
  long twin_blink;
  short fore_color;
  short back_color;
  short blink_color;
  short back_blink_color;
  short top_shadow_color;
  short bottom_shadow_color;
  char* label_string;
  short label_pixmap;
  short blink_pixmap;
  short push_pixmap;
  short press_state;
  long  orientation;
  long  gradation;
  long  gradation_margin;
  long  margin_left;
  long  margin_right;
  long  margin_top;
  long  margin_bottom;
  WSCbool  focus_border;
  WSCbool  emboss;
  WSCuchar font;
  WSCbool  reverse_flag;
  WSCbool  enable_focus_move;
  WSCbool  no_background;
};

#endif
