//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVLABEL_H
#define WSCVLABEL_H

#include <WScom.h>
#include <WSCnwbase.h>
#define WSCvlabel_VER  1000

#define WS_VLABEL_MAXLEN_DEFAULT 64

class WSCvlabel   :public WSCnwbase{

  protected:
    short     _select_color;
    short     _select_fore_color;
    short     _ts_color;
    short     _bs_color;
    short     _back_color;
    short     _bg_blink_color;
    char*     _label_string;
    short     _label_pixmap;
    short     _blink_pixmap;
    WSCushort _max_length;
    WSCuchar  _grad_no;
    WSCuchar  _grad_margin;
    unsigned  _margin_top:4;
    unsigned  _margin_bottom:4;
    unsigned  _margin_left:4;
    unsigned  _margin_right:4;
    unsigned  _shadow_thick:4;
    signed    _shadow_type:4;
    unsigned  _bl_type:2;
    unsigned  _rv_fl:1;
    unsigned  _bit_map:1;
    unsigned  _use_pix:1;
    unsigned  _emboss:1;
    unsigned  _font:4;
    unsigned  _alignment_v:3;
    unsigned  _alignment_h:2;
    unsigned  _orientation:1;

    WSMFpropertyDef(WSNtopShadowColor,    short,     _ts_color);
    WSMFpropertyDef(WSNbottomShadowColor, short,     _bs_color);
    WSMFpropertyDef(WSNshadowType,        char,      _shadow_type);
    WSMFpropertyDef(WSNshadowThickness,   WSCuchar, _shadow_thick);
    WSMFpropertyDef(WSNbackColor,         short,     _back_color);
    WSMFpropertyDef(WSNbackBlinkColor,    short,     _bg_blink_color);
    WSMFpropertyDef(WSNreverseFlag,       WSCbool,   _rv_fl);
    WSMFpropertyDef(WSNblinkType,         WSCuchar,  _bl_type);
    WSMFpropertyDef(WSNemboss,            WSCbool,   _emboss);
    WSMFpropertyDef(WSNusePixmap,         WSCbool,  _use_pix);
    WSMFpropertyDef(WSNlabelString,  char*,      _label_string );
    WSMFpropertyDef(WSNorientation,  WSCuchar,   _orientation  );
    WSMFpropertyDef(WSNalignmentH,   WSCuchar,   _alignment_h  );
    WSMFpropertyDef(WSNmarginTop,    WSCuchar,   _margin_top   );
    WSMFpropertyDef(WSNmarginBottom, WSCuchar,   _margin_bottom);
    WSMFpropertyDef(WSNalignmentV,   WSCuchar,   _alignment_v  );
    WSMFpropertyDef(WSNmarginLeft,   WSCuchar,   _margin_left  );
    WSMFpropertyDef(WSNmarginRight,  WSCuchar,   _margin_right );
    WSMFpropertyDef(WSNmaxLength,    WSCushort,  _max_length   );
    WSMFpropertyDef(WSNfont,         WSCuchar,   _font         );
    WSMFpropertyDef(WSNlabelPixmap,  short,      _label_pixmap );
    WSMFpropertyDef(WSNblinkPixmap,  short,      _blink_pixmap );
    WSMFpropertyDef(WSNgradation,    WSCuchar,   _grad_no );
    WSMFpropertyDef(WSNgradationMargin,    WSCuchar,   _grad_margin );

    virtual long _device_initialize();
    static WSCuchar _vk_draw;
    static WSCbool _use_icon;
    static WSCstring _bar_pos;
    WSCuchar get_vk_draw();
    void set_vk_draw(WSCuchar);
    WSCbool get_use_icon();
    void set_use_icon(WSCbool);
    WSCstring get_bar_pos();
    void set_bar_pos(WSCstring);

  public:

    WSCvlabel(WSCbase* base, char* name);
    virtual ~WSCvlabel();
    virtual long draw();
    virtual void update();
    virtual char* getDefaultProperty();

    char    getAlignment();
    WSMFguiClassDef(WSCvlabel,WSCnwbase);
    WSMFversionDef(WSCvlabel);
};

#endif //WSCVLABEL_H
