/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.jdo;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.EnhancerClassLoader;
import org.datanucleus.enhancer.jdo.JDOImplementationGenerator;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class JDOImplementationCreator
implements Serializable,
ImplementationCreator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassEnhancer.class.getClassLoader());
    protected final MetaDataManager metaDataMgr;
    protected final EnhancerClassLoader loader;

    public JDOImplementationCreator(MetaDataManager mmgr) {
        this.metaDataMgr = mmgr;
        this.loader = new EnhancerClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Object newInstance(Class cls, ClassLoaderResolver clr) {
        try {
            if (PersistenceCapable.class.isAssignableFrom(cls)) {
                if (Modifier.isAbstract(cls.getModifiers())) {
                    ClassMetaData cmd = (ClassMetaData)this.metaDataMgr.getMetaDataForClass(cls, clr);
                    if (cmd == null) {
                        throw new JDOFatalException("Could not find metadata for class " + cls.getName());
                    }
                    PersistenceCapable obj = this.newInstance(cmd, clr);
                    if (obj == null) {
                        throw new JDOFatalException(LOCALISER.msg("ImplementationCreator.InstanceCreateFailed", (Object)cls.getName()));
                    }
                    if (!this.metaDataMgr.hasMetaDataForClass(obj.getClass().getName())) {
                        this.metaDataMgr.registerImplementationOfAbstractClass(cmd, obj.getClass(), clr);
                    }
                    return obj;
                }
                return cls.newInstance();
            }
            InterfaceMetaData imd = this.metaDataMgr.getMetaDataForInterface(cls, clr);
            if (imd == null) {
                throw new JDOFatalException("Could not find metadata for class/interface " + cls.getName());
            }
            PersistenceCapable obj = this.newInstance(imd, clr);
            if (obj == null) {
                throw new JDOFatalException(LOCALISER.msg("ImplementationCreator.InstanceCreateFailed", (Object)cls.getName()));
            }
            if (!this.metaDataMgr.hasMetaDataForClass(obj.getClass().getName())) {
                this.metaDataMgr.registerPersistentInterface(imd, obj.getClass(), clr);
            }
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new JDOUserException(e.toString(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JDOUserException(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JDOUserException(e.toString(), (Throwable)e);
        }
    }

    protected PersistenceCapable newInstance(InterfaceMetaData imd, ClassLoaderResolver clr) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = clr.classForName(imd.getFullClassName());
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("jdo")) continue;
            String propertyName = methodName;
            if (methodName.startsWith("set")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanSetter(methodName);
            } else if (methodName.startsWith("get")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanGetter(methodName);
            }
            if (imd.getMetaDataForMember(propertyName) != null) continue;
            throw new NucleusUserException(LOCALISER.msg("ImplementationCreator.InterfaceMethodUndefined", (Object)imd.getFullClassName(), (Object)methodName));
        }
        String implClassName = imd.getName() + "Impl";
        String implFullClassName = imd.getPackageName() + '.' + implClassName;
        try {
            this.loader.loadClass(implFullClassName);
        }
        catch (ClassNotFoundException e) {
            JDOImplementationGenerator gen = this.getGenerator(imd, implClassName);
            gen.enhance(clr);
            this.loader.defineClass(implFullClassName, gen.getBytes(), clr);
        }
        Object instance = this.loader.loadClass(implFullClassName).newInstance();
        if (instance instanceof PersistenceCapable) {
            return (PersistenceCapable)instance;
        }
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        StringBuilder implementedInterfacesMsg = new StringBuilder("[");
        String classLoaderPCMsg = "";
        for (int i = 0; i < interfaces.length; ++i) {
            implementedInterfacesMsg.append(interfaces[i].getName());
            if (i < interfaces.length - 1) {
                implementedInterfacesMsg.append(",");
            }
            if (!interfaces[i].getName().equals(PersistenceCapable.class.getName())) continue;
            classLoaderPCMsg = LOCALISER.msg("ImplementationCreator.DifferentClassLoader", interfaces[i].getClassLoader(), (Object)PersistenceCapable.class.getClassLoader());
        }
        implementedInterfacesMsg.append("]");
        throw new JDOException(LOCALISER.msg("ImplementationCreator.NotPCProblem", (Object)implFullClassName, (Object)classLoaderPCMsg, (Object)implementedInterfacesMsg.toString()));
    }

    protected PersistenceCapable newInstance(ClassMetaData cmd, ClassLoaderResolver clr) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = clr.classForName(cmd.getFullClassName());
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!Modifier.isAbstract(methods[i].getModifiers()) || methodName.startsWith("jdo")) continue;
            String propertyName = methodName;
            if (methodName.startsWith("set")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanSetter(methodName);
            } else if (methodName.startsWith("get")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanGetter(methodName);
            }
            if (cmd.getMetaDataForMember(propertyName) != null) continue;
            throw new NucleusUserException(LOCALISER.msg("ImplementationCreator.AbstractClassMethodUndefined", (Object)cmd.getFullClassName(), (Object)methodName));
        }
        String implClassName = cmd.getName() + "Impl";
        String implFullClassName = cmd.getPackageName() + '.' + implClassName;
        try {
            this.loader.loadClass(implFullClassName);
        }
        catch (ClassNotFoundException e) {
            JDOImplementationGenerator gen = this.getGenerator(cmd, implClassName);
            gen.enhance(clr);
            this.loader.defineClass(implFullClassName, gen.getBytes(), clr);
        }
        Object instance = this.loader.loadClass(implFullClassName).newInstance();
        if (instance instanceof PersistenceCapable) {
            return (PersistenceCapable)instance;
        }
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        StringBuilder implementedInterfacesMsg = new StringBuilder("[");
        String classLoaderPCMsg = "";
        for (int i = 0; i < interfaces.length; ++i) {
            implementedInterfacesMsg.append(interfaces[i].getName());
            if (i < interfaces.length - 1) {
                implementedInterfacesMsg.append(",");
            }
            if (!interfaces[i].getName().equals(PersistenceCapable.class.getName())) continue;
            classLoaderPCMsg = LOCALISER.msg("ImplementationCreator.DifferentClassLoader", interfaces[i].getClassLoader(), (Object)PersistenceCapable.class.getClassLoader());
        }
        implementedInterfacesMsg.append("]");
        throw new JDOException(LOCALISER.msg("ImplementationCreator.NotPCProblem", (Object)implFullClassName, (Object)classLoaderPCMsg, (Object)implementedInterfacesMsg.toString()));
    }

    protected JDOImplementationGenerator getGenerator(AbstractClassMetaData acmd, String implClassName) {
        if (acmd instanceof InterfaceMetaData) {
            return new JDOImplementationGenerator((InterfaceMetaData)acmd, implClassName, this.metaDataMgr);
        }
        if (acmd instanceof ClassMetaData) {
            return new JDOImplementationGenerator((ClassMetaData)acmd, implClassName, this.metaDataMgr);
        }
        return null;
    }
}

