/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hcatalog.hbase.HBaseBaseOutputFormat;
import org.apache.hcatalog.hbase.HBaseRevisionManagerUtil;
import org.apache.hcatalog.hbase.HBaseUtil;
import org.apache.hcatalog.hbase.ImportSequenceFile;
import org.apache.hcatalog.hbase.snapshot.RevisionManager;

class HBaseBulkOutputFormat
extends HBaseBaseOutputFormat {
    private static final ImmutableBytesWritable EMPTY_LIST = new ImmutableBytesWritable(new byte[0]);
    private SequenceFileOutputFormat<WritableComparable<?>, Put> baseOutputFormat = new SequenceFileOutputFormat();

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.baseOutputFormat.checkOutputSpecs(ignored, job);
        HBaseUtil.addHBaseDelegationToken(job);
        this.addJTDelegationToken(job);
    }

    @Override
    public RecordWriter<WritableComparable<?>, Put> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Put.class);
        long version = HBaseRevisionManagerUtil.getOutputRevision((Configuration)job);
        return new HBaseBulkRecordWriter(this.baseOutputFormat.getRecordWriter(ignored, job, name, progress), version);
    }

    private void addJTDelegationToken(JobConf job) throws IOException {
        if (User.isSecurityEnabled()) {
            JobClient jobClient = new JobClient(new JobConf((Configuration)job));
            try {
                job.getCredentials().addToken(new Text("my mr token"), jobClient.getDelegationToken(null));
            }
            catch (InterruptedException e) {
                throw new IOException("Error while getting JT delegation token", e);
            }
        }
    }

    public static class HBaseBulkOutputCommitter
    extends OutputCommitter {
        private final OutputCommitter baseOutputCommitter = new FileOutputCommitter();

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
            this.baseOutputCommitter.abortTask(taskContext);
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return this.baseOutputCommitter.needsTaskCommit(taskContext);
        }

        public void setupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
            this.baseOutputCommitter.setupJob(jobContext);
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
            this.baseOutputCommitter.setupTask(taskContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortJob(org.apache.hadoop.mapred.JobContext jobContext, int status) throws IOException {
            this.baseOutputCommitter.abortJob(jobContext, status);
            RevisionManager rm = null;
            try {
                rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(jobContext.getConfiguration());
                rm.abortWriteTransaction(HBaseRevisionManagerUtil.getWriteTransaction(jobContext.getConfiguration()));
            }
            finally {
                this.cleanIntermediate(jobContext);
                if (rm != null) {
                    rm.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
            this.baseOutputCommitter.commitJob(jobContext);
            RevisionManager rm = null;
            try {
                Configuration conf = jobContext.getConfiguration();
                Path srcPath = FileOutputFormat.getOutputPath((JobConf)jobContext.getJobConf());
                if (!FileSystem.get((Configuration)conf).exists(srcPath)) {
                    throw new IOException("Failed to bulk import hfiles. Intermediate data directory is cleaned up or missing. Please look at the bulk import job if it exists for failure reason");
                }
                Path destPath = new Path(srcPath.getParent(), srcPath.getName() + "_hfiles");
                boolean success = ImportSequenceFile.runJob((JobContext)jobContext, conf.get("hcat.hbase.mapreduce.outputTableName"), srcPath, destPath);
                if (!success) {
                    this.cleanIntermediate(jobContext);
                    throw new IOException("Failed to bulk import hfiles. Please look at the bulk import job for failure reason");
                }
                rm = HBaseRevisionManagerUtil.getOpenedRevisionManager(conf);
                rm.commitWriteTransaction(HBaseRevisionManagerUtil.getWriteTransaction(conf));
                this.cleanIntermediate(jobContext);
            }
            finally {
                if (rm != null) {
                    rm.close();
                }
            }
        }

        private void cleanIntermediate(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)jobContext.getConfiguration());
            fs.delete(FileOutputFormat.getOutputPath((JobConf)jobContext.getJobConf()), true);
        }
    }

    private static class HBaseBulkRecordWriter
    implements RecordWriter<WritableComparable<?>, Put> {
        private RecordWriter<WritableComparable<?>, Put> baseWriter;
        private final Long outputVersion;

        public HBaseBulkRecordWriter(RecordWriter<WritableComparable<?>, Put> baseWriter, Long outputVersion) {
            this.baseWriter = baseWriter;
            this.outputVersion = outputVersion;
        }

        public void write(WritableComparable<?> key, Put value) throws IOException {
            Put put = value;
            if (this.outputVersion != null) {
                put = new Put(value.getRow(), this.outputVersion.longValue());
                for (List row : value.getFamilyMap().values()) {
                    for (KeyValue el : row) {
                        put.add(el.getFamily(), el.getQualifier(), el.getValue());
                    }
                }
            }
            this.baseWriter.write((Object)EMPTY_LIST, (Object)put);
        }

        public void close(Reporter reporter) throws IOException {
            this.baseWriter.close(reporter);
        }
    }
}

