/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.hbase.HbaseSnapshotRecordReader;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;

class HBaseInputFormat
implements InputFormat<ImmutableBytesWritable, Result> {
    private final TableInputFormat inputFormat = new TableInputFormat();

    public RecordReader<ImmutableBytesWritable, Result> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        String jobString = job.get("mapreduce.lib.hcat.job.info");
        InputJobInfo inputJobInfo = (InputJobInfo)HCatUtil.deserialize((String)jobString);
        String tableName = job.get("hbase.mapreduce.inputtable");
        org.apache.hadoop.hbase.mapred.TableSplit tSplit = (org.apache.hadoop.hbase.mapred.TableSplit)split;
        HbaseSnapshotRecordReader recordReader = new HbaseSnapshotRecordReader(inputJobInfo, (Configuration)job);
        this.inputFormat.setConf((Configuration)job);
        Scan inputScan = this.inputFormat.getScan();
        inputScan.setCaching(200);
        inputScan.setCacheBlocks(false);
        Scan sc = new Scan(inputScan);
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        recordReader.setScan(sc);
        recordReader.setHTable(new HTable((Configuration)job, tableName));
        recordReader.init();
        return recordReader;
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.inputFormat.setConf((Configuration)job);
        return this.convertSplits(this.inputFormat.getSplits((JobContext)HCatMapRedUtil.createJobContext((JobConf)job, null, (Progressable)Reporter.NULL)));
    }

    private org.apache.hadoop.mapred.InputSplit[] convertSplits(List<InputSplit> splits) {
        org.apache.hadoop.mapred.InputSplit[] converted = new org.apache.hadoop.mapred.InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            TableSplit tableSplit = (TableSplit)splits.get(i);
            org.apache.hadoop.hbase.mapred.TableSplit newTableSplit = new org.apache.hadoop.hbase.mapred.TableSplit(tableSplit.getTableName(), tableSplit.getStartRow(), tableSplit.getEndRow(), tableSplit.getRegionLocation());
            converted[i] = newTableSplit;
        }
        return converted;
    }
}

