/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.hbase.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hcatalog.hbase.snapshot.FamilyRevision;

public class Transaction
implements Serializable {
    private String tableName;
    private List<String> columnFamilies = new ArrayList<String>();
    private long timeStamp;
    private long keepAlive;
    private long revision;

    Transaction(String tableName, List<String> columnFamilies, long revision, long timestamp) {
        this.tableName = tableName;
        this.columnFamilies = columnFamilies;
        this.timeStamp = timestamp;
        this.revision = revision;
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumnFamilies() {
        return this.columnFamilies;
    }

    long getTransactionExpireTimeStamp() {
        return this.timeStamp + this.keepAlive;
    }

    void setKeepAlive(long seconds) {
        this.keepAlive = seconds;
    }

    public long getKeepAliveValue() {
        return this.keepAlive;
    }

    FamilyRevision getFamilyRevisionInfo() {
        return new FamilyRevision(this.revision, this.getTransactionExpireTimeStamp());
    }

    void keepAliveTransaction() {
        this.timeStamp += this.keepAlive;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Revision : ");
        sb.append(this.getRevisionNumber());
        sb.append(" Timestamp : ");
        sb.append(this.getTransactionExpireTimeStamp());
        sb.append("\n").append("Table : ");
        sb.append(this.tableName).append("\n");
        sb.append("Column Families : ");
        sb.append(this.columnFamilies.toString());
        return sb.toString();
    }
}

