/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import javax.servlet.Servlet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.Shell;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpServlet;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class ThriftHttpCLIService
extends ThriftCLIService {
    public ThriftHttpCLIService(CLIService cliService) {
        super(cliService, "ThriftHttpCLIService");
    }

    @Override
    public void run() {
        try {
            ThriftHttpCLIService.verifyHttpConfiguration(this.hiveConf);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_HTTP_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT);
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_WORKER_THREADS);
            String httpPath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH);
            if (httpPath == null || httpPath.equals("")) {
                httpPath = "/*";
            } else {
                if (!httpPath.startsWith("/")) {
                    httpPath = "/" + httpPath;
                }
                if (httpPath.endsWith("/")) {
                    httpPath = httpPath + "*";
                }
                if (!httpPath.endsWith("/*")) {
                    httpPath = httpPath + "/*";
                }
            }
            this.httpServer = new Server();
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setMinThreads(this.minWorkerThreads);
            threadPool.setMaxThreads(this.maxWorkerThreads);
            this.httpServer.setThreadPool((ThreadPool)threadPool);
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.portNum);
            connector.setReuseAddress(!Shell.WINDOWS);
            this.httpServer.addConnector((Connector)connector);
            TCLIService.Processor<EmbeddedThriftBinaryCLIService> processor = new TCLIService.Processor<EmbeddedThriftBinaryCLIService>(new EmbeddedThriftBinaryCLIService());
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet(processor, (TProtocolFactory)protocolFactory);
            Context context = new Context((HandlerContainer)this.httpServer, "/", 1);
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            this.httpServer.start();
            String msg = "Starting CLIService in Http mode on port " + this.portNum + " path=" + httpPath + " with " + this.minWorkerThreads + ".." + this.maxWorkerThreads + " worker threads";
            LOG.info((Object)msg);
            this.httpServer.join();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error: ", t);
        }
    }

    private static void verifyHttpConfiguration(HiveConf hiveConf) {
        String authType = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if (authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.KERBEROS.toString()) || authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.LDAP.toString()) || authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.CUSTOM.toString())) {
            String msg = HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION + " setting of " + authType + " is currently not supported with " + HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE + " setting of http";
            LOG.fatal((Object)msg);
            throw new RuntimeException(msg);
        }
        if (authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.NONE.toString())) {
            LOG.warn((Object)(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION + " setting to " + authType + ". SASL is not supported with http transportMode," + " so using equivalent of " + (Object)((Object)HiveAuthFactory.AuthTypes.NOSASL)));
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            String msg = HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS + " setting of " + "true is currently not supported with " + HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE + " setting of http";
            LOG.fatal((Object)msg);
            throw new RuntimeException(msg);
        }
    }
}

