/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class MetaEditor {
    private static final Log LOG = LogFactory.getLog(MetaEditor.class);

    private static Put makePutFromRegionInfo(HRegionInfo regionInfo) throws IOException {
        Put put2 = new Put(regionInfo.getRegionName());
        put2.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)regionInfo));
        return put2;
    }

    static void putToMetaTable(CatalogTracker ct, Put p) throws IOException {
        MetaEditor.put(MetaReader.getMetaHTable(ct), p);
    }

    static void putToRootTable(CatalogTracker ct, Put p) throws IOException {
        MetaEditor.put(MetaReader.getRootHTable(ct), p);
    }

    static void putToCatalogTable(CatalogTracker ct, Put p) throws IOException {
        HTable t = MetaReader.getCatalogHTable(ct, p.getRow());
        MetaEditor.put(t, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(HTable t, Put p) throws IOException {
        try {
            t.put(p);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putsToMetaTable(CatalogTracker ct, List<Put> ps) throws IOException {
        HTable t = MetaReader.getMetaHTable(ct);
        try {
            t.put(ps);
        }
        finally {
            t.close();
        }
    }

    static void deleteFromMetaTable(CatalogTracker ct, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaEditor.deleteFromMetaTable(ct, dels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromMetaTable(CatalogTracker ct, List<Delete> deletes) throws IOException {
        HTable t = MetaReader.getMetaHTable(ct);
        try {
            t.delete(deletes);
        }
        finally {
            t.close();
        }
    }

    static void mutateMetaTable(CatalogTracker ct, List<Mutation> mutations) throws IOException {
        HTable t = MetaReader.getMetaHTable(ct);
        try {
            t.batch(mutations);
        }
        catch (InterruptedException e) {
            InterruptedIOException ie = new InterruptedIOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        finally {
            t.close();
        }
    }

    public static void addRegionToMeta(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        MetaEditor.putToMetaTable(catalogTracker, MetaEditor.makePutFromRegionInfo(regionInfo));
        LOG.info((Object)("Added region " + regionInfo.getRegionNameAsString() + " to META"));
    }

    public static void addRegionsToMeta(CatalogTracker catalogTracker, List<HRegionInfo> regionInfos) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (HRegionInfo regionInfo : regionInfos) {
            puts.add(MetaEditor.makePutFromRegionInfo(regionInfo));
        }
        MetaEditor.putsToMetaTable(catalogTracker, puts);
        LOG.info((Object)("Added " + puts.size() + " regions in META"));
    }

    public static void offlineParentInMeta(CatalogTracker catalogTracker, HRegionInfo parent, HRegionInfo a, HRegionInfo b) throws NotAllMetaRegionsOnlineException, IOException {
        HRegionInfo copyOfParent = new HRegionInfo(parent);
        copyOfParent.setOffline(true);
        copyOfParent.setSplit(true);
        Put put2 = new Put(copyOfParent.getRegionName());
        MetaEditor.addRegionInfo(put2, copyOfParent);
        put2.add(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, Writables.getBytes((Writable)a));
        put2.add(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, Writables.getBytes((Writable)b));
        MetaEditor.putToMetaTable(catalogTracker, put2);
        LOG.info((Object)("Offlined parent region " + parent.getRegionNameAsString() + " in META"));
    }

    public static void addDaughter(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn) throws NotAllMetaRegionsOnlineException, IOException {
        Put put2 = new Put(regionInfo.getRegionName());
        MetaEditor.addRegionInfo(put2, regionInfo);
        if (sn != null) {
            MetaEditor.addLocation(put2, sn);
        }
        MetaEditor.putToMetaTable(catalogTracker, put2);
        LOG.info((Object)("Added daughter " + regionInfo.getRegionNameAsString() + (sn == null ? ", serverName=null" : ", serverName=" + sn.toString())));
    }

    public static void updateMetaLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn) throws IOException, ConnectException {
        MetaEditor.updateLocation(catalogTracker, regionInfo, sn);
    }

    public static void updateRegionLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn) throws IOException {
        MetaEditor.updateLocation(catalogTracker, regionInfo, sn);
    }

    private static void updateLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo, ServerName sn) throws IOException {
        Put put2 = new Put(regionInfo.getRegionName());
        MetaEditor.addLocation(put2, sn);
        MetaEditor.putToCatalogTable(catalogTracker, put2);
        LOG.info((Object)("Updated row " + regionInfo.getRegionNameAsString() + " with server=" + sn));
    }

    public static void deleteRegion(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        Delete delete = new Delete(regionInfo.getRegionName());
        MetaEditor.deleteFromMetaTable(catalogTracker, delete);
        LOG.info((Object)("Deleted region " + regionInfo.getRegionNameAsString() + " from META"));
    }

    public static void deleteRegions(CatalogTracker catalogTracker, List<HRegionInfo> regionsInfo) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(regionsInfo.size());
        for (HRegionInfo hri : regionsInfo) {
            deletes.add(new Delete(hri.getRegionName()));
        }
        MetaEditor.deleteFromMetaTable(catalogTracker, deletes);
        LOG.info((Object)("Deleted from META, regions: " + regionsInfo));
    }

    public static void mutateRegions(CatalogTracker catalogTracker, List<HRegionInfo> regionsToRemove, List<HRegionInfo> regionsToAdd) throws IOException {
        ArrayList<Mutation> mutation = new ArrayList<Mutation>();
        if (regionsToRemove != null) {
            for (HRegionInfo hri : regionsToRemove) {
                mutation.add(new Delete(hri.getRegionName()));
            }
        }
        if (regionsToAdd != null) {
            for (HRegionInfo hri : regionsToAdd) {
                mutation.add(MetaEditor.makePutFromRegionInfo(hri));
            }
        }
        MetaEditor.mutateMetaTable(catalogTracker, mutation);
        if (regionsToRemove != null && regionsToRemove.size() > 0) {
            LOG.debug((Object)("Deleted from META, regions: " + regionsToRemove));
        }
        if (regionsToAdd != null && regionsToAdd.size() > 0) {
            LOG.debug((Object)("Add to META, regions: " + regionsToAdd));
        }
    }

    public static void deleteDaughtersReferencesInParent(CatalogTracker catalogTracker, HRegionInfo parent) throws NotAllMetaRegionsOnlineException, IOException {
        Delete delete = new Delete(parent.getRegionName());
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER);
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER);
        MetaEditor.deleteFromMetaTable(catalogTracker, delete);
        LOG.info((Object)("Deleted daughters references, qualifier=" + Bytes.toStringBinary(HConstants.SPLITA_QUALIFIER) + " and qualifier=" + Bytes.toStringBinary(HConstants.SPLITB_QUALIFIER) + ", from parent " + parent.getRegionNameAsString()));
    }

    public static HRegionInfo getHRegionInfo(Result data) throws IOException {
        byte[] bytes = data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            return null;
        }
        HRegionInfo info = Writables.getHRegionInfo(bytes);
        LOG.info((Object)("Current INFO from scan results = " + (Object)((Object)info)));
        return info;
    }

    public static PairOfSameType<HRegionInfo> getDaughterRegions(Result data) throws IOException {
        HRegionInfo splitA = Writables.getHRegionInfoOrNull(data.getValue(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER));
        HRegionInfo splitB = Writables.getHRegionInfoOrNull(data.getValue(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER));
        return new PairOfSameType<HRegionInfo>(splitA, splitB);
    }

    private static Put addRegionInfo(Put p, HRegionInfo hri) throws IOException {
        p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        return p;
    }

    private static Put addLocation(Put p, ServerName sn) {
        p.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(sn.getHostAndPort()));
        p.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes(sn.getStartcode()));
        return p;
    }
}

