/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class Mutation
extends OperationWithAttributes
implements Row {
    private static final String CLUSTER_ID_ATTR = "_c.id_";
    protected byte[] row = null;
    protected long ts = Long.MAX_VALUE;
    protected long lockId = -1L;
    protected boolean writeToWAL = true;
    protected Map<byte[], List<KeyValue>> familyMap = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary(this.row));
        int colCount = 0;
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            ArrayList<Map<String, Object>> qualifierDetails = new ArrayList<Map<String, Object>>();
            columns.put(Bytes.toStringBinary(entry.getKey()), qualifierDetails);
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (KeyValue kv : entry.getValue()) {
                if (--maxCols <= 0) continue;
                Map<String, Object> kvMap = kv.toStringMap();
                kvMap.remove("row");
                kvMap.remove("family");
                qualifierDetails.add(kvMap);
            }
        }
        map.put("totalColumns", colCount);
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    public boolean getWriteToWAL() {
        return this.writeToWAL;
    }

    public void setWriteToWAL(boolean write) {
        this.writeToWAL = write;
    }

    public Map<byte[], List<KeyValue>> getFamilyMap() {
        return this.familyMap;
    }

    public void setFamilyMap(Map<byte[], List<KeyValue>> map) {
        this.familyMap = map;
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public int compareTo(Row d) {
        return Bytes.compareTo(this.getRow(), d.getRow());
    }

    public RowLock getRowLock() {
        return new RowLock(this.row, this.lockId);
    }

    public long getLockId() {
        return this.lockId;
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public void setClusterId(UUID clusterId) {
        if (clusterId == null) {
            return;
        }
        byte[] val = new byte[16];
        Bytes.putLong(val, 0, clusterId.getMostSignificantBits());
        Bytes.putLong(val, 8, clusterId.getLeastSignificantBits());
        this.setAttribute(CLUSTER_ID_ATTR, val);
    }

    public UUID getClusterId() {
        byte[] attr = this.getAttribute(CLUSTER_ID_ATTR);
        if (attr == null) {
            return HConstants.DEFAULT_CLUSTER_ID;
        }
        return new UUID(Bytes.toLong(attr, 0), Bytes.toLong(attr, 8));
    }

    public int size() {
        int size = 0;
        for (List<KeyValue> kvList : this.familyMap.values()) {
            size += kvList.size();
        }
        return size;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }
}

