/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.OutputStream;

public class DoubleOutputStream
extends OutputStream {
    private OutputStream out1;
    private OutputStream out2;

    public DoubleOutputStream(OutputStream out1, OutputStream out2) {
        this.out1 = out1;
        this.out2 = out2;
    }

    @Override
    public void write(int b) throws IOException {
        this.out1.write(b);
        this.out2.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out1.write(b, 0, b.length);
        this.out2.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out1.write(b, off, len);
        this.out2.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out1.flush();
        this.out2.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.out1.close();
        }
        finally {
            this.out2.close();
        }
    }
}

