/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

public class BlockCacheColumnFamilySummary
implements Writable,
Comparable<BlockCacheColumnFamilySummary> {
    private String table = "";
    private String columnFamily = "";
    private int blocks;
    private long heapSize;

    public BlockCacheColumnFamilySummary() {
    }

    public BlockCacheColumnFamilySummary(String table, String columnFamily) {
        this.table = table;
        this.columnFamily = columnFamily;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
    }

    public int getBlocks() {
        return this.blocks;
    }

    public void setBlocks(int blocks) {
        this.blocks = blocks;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public void incrementBlocks() {
        ++this.blocks;
    }

    public void incrementHeapSize(long heapSize) {
        this.heapSize += heapSize;
    }

    public void setHeapSize(long heapSize) {
        this.heapSize = heapSize;
    }

    public void readFields(DataInput in) throws IOException {
        this.table = in.readUTF();
        this.columnFamily = in.readUTF();
        this.blocks = in.readInt();
        this.heapSize = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.table);
        out.writeUTF(this.columnFamily);
        out.writeInt(this.blocks);
        out.writeLong(this.heapSize);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnFamily == null ? 0 : this.columnFamily.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockCacheColumnFamilySummary other = (BlockCacheColumnFamilySummary)obj;
        if (this.columnFamily == null ? other.columnFamily != null : !this.columnFamily.equals(other.columnFamily)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public String toString() {
        return "BlockCacheSummaryEntry [table=" + this.table + ", columnFamily=" + this.columnFamily + ", blocks=" + this.blocks + ", heapSize=" + this.heapSize + "]";
    }

    public static BlockCacheColumnFamilySummary createFromStoreFilePath(Path path) {
        String sp = path.toString();
        String[] s = sp.split("\\/");
        BlockCacheColumnFamilySummary bcse = null;
        if (s.length >= 4) {
            String table = s[s.length - 4];
            String cf = s[s.length - 2];
            bcse = new BlockCacheColumnFamilySummary(table, cf);
        }
        return bcse;
    }

    @Override
    public int compareTo(BlockCacheColumnFamilySummary o) {
        int i = this.table.compareTo(o.getTable());
        if (i != 0) {
            return i;
        }
        return this.columnFamily.compareTo(o.getColumnFamily());
    }

    public static BlockCacheColumnFamilySummary create(BlockCacheColumnFamilySummary e) {
        BlockCacheColumnFamilySummary e2 = new BlockCacheColumnFamilySummary();
        e2.setTable(e.getTable());
        e2.setColumnFamily(e.getColumnFamily());
        return e2;
    }
}

