/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV1;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV1;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;

public class HFile {
    static final Log LOG = LogFactory.getLog(HFile.class);
    public static final int MAXIMUM_KEY_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final Compression.Algorithm DEFAULT_COMPRESSION_ALGORITHM = Compression.Algorithm.NONE;
    public static final int MIN_FORMAT_VERSION = 1;
    public static final int MAX_FORMAT_VERSION = 2;
    public static final String DEFAULT_COMPRESSION = DEFAULT_COMPRESSION_ALGORITHM.getName();
    public static final int MIN_NUM_HFILE_PATH_LEVELS = 5;
    public static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    public static final ChecksumType DEFAULT_CHECKSUM_TYPE = ChecksumType.CRC32;
    private static final AtomicInteger readOps = new AtomicInteger();
    private static final AtomicLong readTimeNano = new AtomicLong();
    private static final AtomicInteger writeOps = new AtomicInteger();
    private static final AtomicLong writeTimeNano = new AtomicLong();
    private static final AtomicInteger preadOps = new AtomicInteger();
    private static final AtomicLong preadTimeNano = new AtomicLong();
    static final AtomicLong checksumFailures = new AtomicLong();
    private static final int LATENCY_BUFFER_SIZE = 5000;
    private static final BlockingQueue<Long> fsReadLatenciesNanos = new ArrayBlockingQueue<Long>(5000);
    private static final BlockingQueue<Long> fsWriteLatenciesNanos = new ArrayBlockingQueue<Long>(5000);
    private static final BlockingQueue<Long> fsPreadLatenciesNanos = new ArrayBlockingQueue<Long>(5000);
    public static volatile AtomicLong dataBlockReadCnt = new AtomicLong(0L);
    public static final String FORMAT_VERSION_KEY = "hfile.format.version";

    public static final void offerReadLatency(long latencyNanos, boolean pread) {
        if (pread) {
            fsPreadLatenciesNanos.offer(latencyNanos);
            preadOps.incrementAndGet();
            preadTimeNano.addAndGet(latencyNanos);
        } else {
            fsReadLatenciesNanos.offer(latencyNanos);
            readTimeNano.addAndGet(latencyNanos);
            readOps.incrementAndGet();
        }
    }

    public static final void offerWriteLatency(long latencyNanos) {
        fsWriteLatenciesNanos.offer(latencyNanos);
        writeTimeNano.addAndGet(latencyNanos);
        writeOps.incrementAndGet();
    }

    public static final Collection<Long> getReadLatenciesNanos() {
        ArrayList latencies = Lists.newArrayListWithCapacity((int)fsReadLatenciesNanos.size());
        fsReadLatenciesNanos.drainTo(latencies);
        return latencies;
    }

    public static final Collection<Long> getPreadLatenciesNanos() {
        ArrayList latencies = Lists.newArrayListWithCapacity((int)fsPreadLatenciesNanos.size());
        fsPreadLatenciesNanos.drainTo(latencies);
        return latencies;
    }

    public static final Collection<Long> getWriteLatenciesNanos() {
        ArrayList latencies = Lists.newArrayListWithCapacity((int)fsWriteLatenciesNanos.size());
        fsWriteLatenciesNanos.drainTo(latencies);
        return latencies;
    }

    public static final int getReadOps() {
        return readOps.getAndSet(0);
    }

    public static final long getReadTimeMs() {
        return readTimeNano.getAndSet(0L) / 1000000L;
    }

    public static final int getPreadOps() {
        return preadOps.getAndSet(0);
    }

    public static final long getPreadTimeMs() {
        return preadTimeNano.getAndSet(0L) / 1000000L;
    }

    public static final int getWriteOps() {
        return writeOps.getAndSet(0);
    }

    public static final long getWriteTimeMs() {
        return writeTimeNano.getAndSet(0L) / 1000000L;
    }

    public static final long getChecksumFailuresCount() {
        return checksumFailures.getAndSet(0L);
    }

    public static int getFormatVersion(Configuration conf) {
        int version = conf.getInt(FORMAT_VERSION_KEY, 2);
        HFile.checkFormatVersion(version);
        return version;
    }

    public static final WriterFactory getWriterFactoryNoCache(Configuration conf) {
        Configuration tempConf = new Configuration(conf);
        tempConf.setFloat("hfile.block.cache.size", 0.0f);
        return HFile.getWriterFactory(conf, new CacheConfig(tempConf));
    }

    public static final WriterFactory getWriterFactory(Configuration conf, CacheConfig cacheConf) {
        SchemaMetrics.configureGlobally(conf);
        int version = HFile.getFormatVersion(conf);
        switch (version) {
            case 1: {
                return new HFileWriterV1.WriterFactoryV1(conf, cacheConf);
            }
            case 2: {
                return new HFileWriterV2.WriterFactoryV2(conf, cacheConf);
            }
        }
        throw new IllegalArgumentException("Cannot create writer for HFile format version " + version);
    }

    private static Reader pickReaderVersion(Path path, FSDataInputStream fsdis, FSDataInputStream fsdisNoFsChecksum, long size, boolean closeIStream, CacheConfig cacheConf, DataBlockEncoding preferredEncodingInCache, HFileSystem hfs) throws IOException {
        FixedFileTrailer trailer = null;
        try {
            trailer = FixedFileTrailer.readFromStream(fsdis, size);
        }
        catch (IllegalArgumentException iae) {
            throw new CorruptHFileException("Problem reading HFile Trailer from file " + path, iae);
        }
        switch (trailer.getMajorVersion()) {
            case 1: {
                return new HFileReaderV1(path, trailer, fsdis, size, closeIStream, cacheConf);
            }
            case 2: {
                return new HFileReaderV2(path, trailer, fsdis, fsdisNoFsChecksum, size, closeIStream, cacheConf, preferredEncodingInCache, hfs);
            }
        }
        throw new CorruptHFileException("Invalid HFile version " + trailer.getMajorVersion());
    }

    public static Reader createReaderWithEncoding(FileSystem fs, Path path, CacheConfig cacheConf, DataBlockEncoding preferredEncodingInCache) throws IOException {
        FSDataInputStream fsdis;
        boolean closeIStream = true;
        HFileSystem hfs = null;
        FSDataInputStream fsdisNoFsChecksum = fsdis = fs.open(path);
        if (!(fs instanceof HFileSystem)) {
            hfs = new HFileSystem(fs);
        } else {
            hfs = (HFileSystem)fs;
            if (hfs != null) {
                fsdisNoFsChecksum = hfs.getNoChecksumFs().open(path);
            }
        }
        return HFile.pickReaderVersion(path, fsdis, fsdisNoFsChecksum, fs.getFileStatus(path).getLen(), true, cacheConf, preferredEncodingInCache, hfs);
    }

    public static Reader createReaderWithEncoding(FileSystem fs, Path path, FSDataInputStream fsdis, FSDataInputStream fsdisNoFsChecksum, long size, CacheConfig cacheConf, DataBlockEncoding preferredEncodingInCache, boolean closeIStream) throws IOException {
        HFileSystem hfs = null;
        hfs = !(fs instanceof HFileSystem) ? new HFileSystem(fs) : (HFileSystem)fs;
        return HFile.pickReaderVersion(path, fsdis, fsdisNoFsChecksum, size, closeIStream, cacheConf, preferredEncodingInCache, hfs);
    }

    public static Reader createReader(FileSystem fs, Path path, CacheConfig cacheConf) throws IOException {
        return HFile.createReaderWithEncoding(fs, path, cacheConf, DataBlockEncoding.NONE);
    }

    static Reader createReaderFromStream(Path path, FSDataInputStream fsdis, long size, CacheConfig cacheConf) throws IOException {
        boolean closeIStream = false;
        return HFile.pickReaderVersion(path, fsdis, fsdis, size, false, cacheConf, DataBlockEncoding.NONE, null);
    }

    public static boolean isReservedFileInfoKey(byte[] key) {
        return Bytes.startsWith(key, FileInfo.RESERVED_PREFIX_BYTES);
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return Compression.getSupportedAlgorithms();
    }

    static int longToInt(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    static List<Path> getStoreFiles(FileSystem fs, Path regionDir) throws IOException {
        FileStatus[] familyDirs;
        ArrayList<Path> res = new ArrayList<Path>();
        FSUtils.DirFilter dirFilter = new FSUtils.DirFilter(fs);
        for (FileStatus dir : familyDirs = fs.listStatus(regionDir, (PathFilter)dirFilter)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(dir.getPath())) {
                if (file.isDir()) continue;
                res.add(file.getPath());
            }
        }
        return res;
    }

    public static void main(String[] args) throws IOException {
        HFilePrettyPrinter prettyPrinter = new HFilePrettyPrinter();
        System.exit(prettyPrinter.run(args));
    }

    public static void checkFormatVersion(int version) throws IllegalArgumentException {
        if (version < 1 || version > 2) {
            throw new IllegalArgumentException("Invalid HFile version: " + version + " (expected to be " + "between " + 1 + " and " + 2 + ")");
        }
    }

    static class FileInfo
    extends HbaseMapWritable<byte[], byte[]> {
        static final String RESERVED_PREFIX = "hfile.";
        static final byte[] RESERVED_PREFIX_BYTES = Bytes.toBytes("hfile.");
        static final byte[] LASTKEY = Bytes.toBytes("hfile.LASTKEY");
        static final byte[] AVG_KEY_LEN = Bytes.toBytes("hfile.AVG_KEY_LEN");
        static final byte[] AVG_VALUE_LEN = Bytes.toBytes("hfile.AVG_VALUE_LEN");
        static final byte[] COMPARATOR = Bytes.toBytes("hfile.COMPARATOR");

        FileInfo() {
        }

        public FileInfo append(byte[] k, byte[] v, boolean checkPrefix) throws IOException {
            if (k == null || v == null) {
                throw new NullPointerException("Key nor value may be null");
            }
            if (checkPrefix && HFile.isReservedFileInfoKey(k)) {
                throw new IOException("Keys with a hfile. are reserved");
            }
            this.put(k, v);
            return this;
        }
    }

    public static interface Reader
    extends Closeable,
    CachingBlockReader,
    SchemaMetrics.SchemaAware {
        public String getName();

        @Override
        public String getColumnFamilyName();

        public RawComparator<byte[]> getComparator();

        public HFileScanner getScanner(boolean var1, boolean var2, boolean var3);

        public ByteBuffer getMetaBlock(String var1, boolean var2) throws IOException;

        public Map<byte[], byte[]> loadFileInfo() throws IOException;

        public byte[] getLastKey();

        public byte[] midkey() throws IOException;

        public long length();

        public long getEntries();

        public byte[] getFirstKey();

        public long indexSize();

        public byte[] getFirstRowKey();

        public byte[] getLastRowKey();

        public FixedFileTrailer getTrailer();

        public HFileBlockIndex.BlockIndexReader getDataBlockIndexReader();

        public HFileScanner getScanner(boolean var1, boolean var2);

        public Compression.Algorithm getCompressionAlgorithm();

        public DataInput getGeneralBloomFilterMetadata() throws IOException;

        public DataInput getDeleteBloomFilterMetadata() throws IOException;

        public Path getPath();

        public void close(boolean var1) throws IOException;

        public DataBlockEncoding getEncodingOnDisk();
    }

    public static interface CachingBlockReader {
        public HFileBlock readBlock(long var1, long var3, boolean var5, boolean var6, boolean var7, BlockType var8) throws IOException;
    }

    public static abstract class WriterFactory {
        protected final Configuration conf;
        protected final CacheConfig cacheConf;
        protected FileSystem fs;
        protected Path path;
        protected FSDataOutputStream ostream;
        protected int blockSize = 65536;
        protected Compression.Algorithm compression = DEFAULT_COMPRESSION_ALGORITHM;
        protected HFileDataBlockEncoder encoder = NoOpDataBlockEncoder.INSTANCE;
        protected KeyValue.KeyComparator comparator;
        protected ChecksumType checksumType = DEFAULT_CHECKSUM_TYPE;
        protected int bytesPerChecksum = 16384;

        WriterFactory(Configuration conf, CacheConfig cacheConf) {
            this.conf = conf;
            this.cacheConf = cacheConf;
        }

        public WriterFactory withPath(FileSystem fs, Path path) {
            Preconditions.checkNotNull((Object)fs);
            Preconditions.checkNotNull((Object)path);
            this.fs = fs;
            this.path = path;
            return this;
        }

        public WriterFactory withOutputStream(FSDataOutputStream ostream) {
            Preconditions.checkNotNull((Object)ostream);
            this.ostream = ostream;
            return this;
        }

        public WriterFactory withBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public WriterFactory withCompression(Compression.Algorithm compression) {
            Preconditions.checkNotNull((Object)((Object)compression));
            this.compression = compression;
            return this;
        }

        public WriterFactory withCompression(String compressAlgo) {
            Preconditions.checkNotNull((Object)((Object)this.compression));
            this.compression = AbstractHFileWriter.compressionByName(compressAlgo);
            return this;
        }

        public WriterFactory withDataBlockEncoder(HFileDataBlockEncoder encoder) {
            Preconditions.checkNotNull((Object)encoder);
            this.encoder = encoder;
            return this;
        }

        public WriterFactory withComparator(KeyValue.KeyComparator comparator) {
            Preconditions.checkNotNull((Object)comparator);
            this.comparator = comparator;
            return this;
        }

        public WriterFactory withChecksumType(ChecksumType checksumType) {
            Preconditions.checkNotNull((Object)((Object)checksumType));
            this.checksumType = checksumType;
            return this;
        }

        public WriterFactory withBytesPerChecksum(int bytesPerChecksum) {
            this.bytesPerChecksum = bytesPerChecksum;
            return this;
        }

        public Writer create() throws IOException {
            if ((this.path != null ? 1 : 0) + (this.ostream != null ? 1 : 0) != 1) {
                throw new AssertionError((Object)"Please specify exactly one of filesystem/path or path");
            }
            if (this.path != null) {
                this.ostream = AbstractHFileWriter.createOutputStream(this.conf, this.fs, this.path);
            }
            return this.createWriter(this.fs, this.path, this.ostream, this.blockSize, this.compression, this.encoder, this.comparator, this.checksumType, this.bytesPerChecksum);
        }

        protected abstract Writer createWriter(FileSystem var1, Path var2, FSDataOutputStream var3, int var4, Compression.Algorithm var5, HFileDataBlockEncoder var6, KeyValue.KeyComparator var7, ChecksumType var8, int var9) throws IOException;
    }

    public static interface Writer
    extends Closeable {
        public void appendFileInfo(byte[] var1, byte[] var2) throws IOException;

        public void append(KeyValue var1) throws IOException;

        public void append(byte[] var1, byte[] var2) throws IOException;

        public Path getPath();

        public String getColumnFamilyName();

        public void appendMetaBlock(String var1, Writable var2);

        public void addInlineBlockWriter(InlineBlockWriter var1);

        public void addGeneralBloomFilter(BloomFilterWriter var1);

        public void addDeleteFamilyBloomFilter(BloomFilterWriter var1) throws IOException;
    }
}

