/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;

public class MasterExecRPCInvoker
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.MasterExecRPCInvoker");
    private Configuration conf;
    private final HConnection connection;
    private Class<? extends CoprocessorProtocol> protocol;

    public MasterExecRPCInvoker(Configuration conf, HConnection connection, Class<? extends CoprocessorProtocol> protocol) {
        this.conf = conf;
        this.connection = connection;
        this.protocol = protocol;
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call: " + method.getName() + ", " + (args != null ? args.length : 0)));
        }
        Exec exec = new Exec(this.conf, this.protocol, method, args);
        ExecResult result = this.connection.getMaster().execCoprocessor(exec);
        LOG.debug((Object)("Master Result is value=" + result.getValue()));
        return result.getValue();
    }
}

