/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import org.apache.hadoop.util.StringUtils;

public class TableRecordReaderImpl {
    public static final String LOG_PER_ROW_COUNT = "hbase.mapreduce.log.scanner.rowcount";
    static final Log LOG = LogFactory.getLog(TableRecordReader.class);
    private static final String HBASE_COUNTER_GROUP_NAME = "HBase Counters";
    private ResultScanner scanner = null;
    private Scan scan = null;
    private Scan currentScan = null;
    private HTable htable = null;
    private byte[] lastSuccessfulRow = null;
    private ImmutableBytesWritable key = null;
    private Result value = null;
    private TaskAttemptContext context = null;
    private Method getCounter = null;
    private long numRestarts = 0L;
    private long timestamp;
    private int rowcount;
    private boolean logScannerActivity = false;
    private int logPerRowCount = 100;

    public void restart(byte[] firstRow) throws IOException {
        this.currentScan = new Scan(this.scan);
        this.currentScan.setStartRow(firstRow);
        this.currentScan.setAttribute(Scan.SCAN_ATTRIBUTES_METRICS_ENABLE, Bytes.toBytes(Boolean.TRUE));
        this.scanner = this.htable.getScanner(this.currentScan);
        if (this.logScannerActivity) {
            LOG.info((Object)("Current scan=" + this.currentScan.toString()));
            this.timestamp = System.currentTimeMillis();
            this.rowcount = 0;
        }
    }

    private Method retrieveGetCounterWithStringsParams(TaskAttemptContext context) throws IOException {
        Method m = null;
        try {
            m = context.getClass().getMethod("getCounter", String.class, String.class);
        }
        catch (SecurityException e) {
            throw new IOException("Failed test for getCounter", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    public void setHTable(HTable htable) {
        Configuration conf = htable.getConfiguration();
        this.logScannerActivity = conf.getBoolean("hbase.client.log.scanner.activity", false);
        this.logPerRowCount = conf.getInt(LOG_PER_ROW_COUNT, 100);
        this.htable = htable;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (context != null) {
            this.context = context;
            this.getCounter = this.retrieveGetCounterWithStringsParams(context);
        }
        this.restart(this.scan.getStartRow());
    }

    public void close() {
        this.scanner.close();
    }

    public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Result getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = new ImmutableBytesWritable();
        }
        if (this.value == null) {
            this.value = new Result();
        }
        try {
            try {
                this.value = this.scanner.next();
                if (this.logScannerActivity) {
                    ++this.rowcount;
                    if (this.rowcount >= this.logPerRowCount) {
                        long now = System.currentTimeMillis();
                        LOG.info((Object)("Mapper took " + (now - this.timestamp) + "ms to process " + this.rowcount + " rows"));
                        this.timestamp = now;
                        this.rowcount = 0;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Object)("recovered from " + StringUtils.stringifyException((Throwable)e)));
                if (this.lastSuccessfulRow == null) {
                    LOG.warn((Object)"We are restarting the first next() invocation, if your mapper has restarted a few other times like this then you should consider killing this job and investigate why it's taking so long.");
                }
                if (this.lastSuccessfulRow == null) {
                    this.restart(this.scan.getStartRow());
                } else {
                    this.restart(this.lastSuccessfulRow);
                    this.scanner.next();
                }
                this.value = this.scanner.next();
                ++this.numRestarts;
            }
            if (this.value != null && this.value.size() > 0) {
                this.key.set(this.value.getRow());
                this.lastSuccessfulRow = this.key.get();
                return true;
            }
            this.updateCounters();
            return false;
        }
        catch (IOException ioe) {
            if (this.logScannerActivity) {
                long now = System.currentTimeMillis();
                LOG.info((Object)("Mapper took " + (now - this.timestamp) + "ms to process " + this.rowcount + " rows"));
                LOG.info((Object)ioe);
                String lastRow = this.lastSuccessfulRow == null ? "null" : Bytes.toStringBinary(this.lastSuccessfulRow);
                LOG.info((Object)("lastSuccessfulRow=" + lastRow));
            }
            throw ioe;
        }
    }

    private void updateCounters() throws IOException {
        if (this.getCounter == null) {
            return;
        }
        byte[] serializedMetrics = this.currentScan.getAttribute(Scan.SCAN_ATTRIBUTES_METRICS_DATA);
        if (serializedMetrics == null || serializedMetrics.length == 0) {
            return;
        }
        DataInputBuffer in = new DataInputBuffer();
        in.reset(serializedMetrics, 0, serializedMetrics.length);
        ScanMetrics scanMetrics = new ScanMetrics();
        scanMetrics.readFields((DataInput)in);
        MetricsTimeVaryingLong[] mlvs = scanMetrics.getMetricsTimeVaryingLongArray();
        try {
            for (MetricsTimeVaryingLong mlv : mlvs) {
                Counter ct = (Counter)this.getCounter.invoke((Object)this.context, HBASE_COUNTER_GROUP_NAME, mlv.getName());
                ct.increment(mlv.getCurrentIntervalValue());
            }
            ((Counter)this.getCounter.invoke((Object)this.context, HBASE_COUNTER_GROUP_NAME, "NUM_SCANNER_RESTARTS")).increment(this.numRestarts);
        }
        catch (Exception e) {
            LOG.debug((Object)("can't update counter." + StringUtils.stringifyException((Throwable)e)));
        }
    }

    public float getProgress() {
        return 0.0f;
    }
}

