/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.ServerName;

public class DeadServer
implements Set<ServerName> {
    private final Set<ServerName> deadServers = new HashSet<ServerName>();
    private int numProcessing = 0;

    public boolean isDeadServer(String serverName) {
        return this.isDeadServer(new ServerName(serverName));
    }

    public boolean cleanPreviousInstance(ServerName newServerName) {
        ServerName sn = ServerName.findServerWithSameHostnamePort(this.deadServers, newServerName);
        if (sn == null) {
            return false;
        }
        return this.deadServers.remove(sn);
    }

    boolean isDeadServer(ServerName serverName) {
        return this.deadServers.contains(serverName);
    }

    boolean isDeadServerWithSameHostnamePort(ServerName serverName) {
        return ServerName.findServerWithSameHostnamePort(this.deadServers, serverName) != null;
    }

    public boolean areDeadServersInProgress() {
        return this.numProcessing != 0;
    }

    public synchronized Set<ServerName> clone() {
        HashSet<ServerName> clone = new HashSet<ServerName>(this.deadServers.size());
        clone.addAll(this.deadServers);
        return clone;
    }

    @Override
    public synchronized boolean add(ServerName e) {
        ++this.numProcessing;
        return this.deadServers.add(e);
    }

    public synchronized void finish(ServerName e) {
        --this.numProcessing;
    }

    @Override
    public synchronized int size() {
        return this.deadServers.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.deadServers.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.deadServers.contains(o);
    }

    @Override
    public Iterator<ServerName> iterator() {
        return this.deadServers.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.deadServers.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.deadServers.toArray(a);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.deadServers.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.deadServers.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends ServerName> c) {
        return this.deadServers.addAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.deadServers.retainAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.deadServers.removeAll(c);
    }

    @Override
    public synchronized void clear() {
        throw new NotImplementedException();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return ((Object)this.deadServers).equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return ((Object)this.deadServers).hashCode();
    }

    public synchronized String toString() {
        return this.deadServers.toString();
    }
}

