/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ServerCommandLine;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.KeeperException;

public class HMasterCommandLine
extends ServerCommandLine {
    private static final Log LOG = LogFactory.getLog(HMasterCommandLine.class);
    private static final String USAGE = "Usage: Master [opts] start|stop\n start  Start Master. If local mode, start Master and RegionServer in same JVM\n stop   Start cluster shutdown; Master signals RegionServer shutdown\n where [opts] are:\n   --minServers=<servers>    Minimum RegionServers needed to host user tables.\n   --backup                  Master should start in backup mode";
    private final Class<? extends HMaster> masterClass;

    public HMasterCommandLine(Class<? extends HMaster> masterClass) {
        this.masterClass = masterClass;
    }

    @Override
    protected String getUsage() {
        return USAGE;
    }

    public int run(String[] args) throws Exception {
        List remainingArgs;
        CommandLine cmd;
        Options opt = new Options();
        opt.addOption("minServers", true, "Minimum RegionServers needed to host user tables");
        opt.addOption("backup", false, "Do not try to become HMaster until the primary fails");
        try {
            cmd = new GnuParser().parse(opt, args);
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not parse: ", (Throwable)e);
            this.usage(null);
            return -1;
        }
        if (cmd.hasOption("minServers")) {
            String val = cmd.getOptionValue("minServers");
            this.getConf().setInt("hbase.regions.server.count.min", Integer.valueOf(val).intValue());
            LOG.debug((Object)("minServers set to " + val));
        }
        if (cmd.hasOption("backup")) {
            this.getConf().setBoolean("hbase.master.backup", true);
        }
        if ((remainingArgs = cmd.getArgList()).size() != 1) {
            this.usage(null);
            return -1;
        }
        String command = (String)remainingArgs.get(0);
        if ("start".equals(command)) {
            return this.startMaster();
        }
        if ("stop".equals(command)) {
            return this.stopMaster();
        }
        this.usage("Invalid command: " + command);
        return -1;
    }

    private int startMaster() {
        Configuration conf = this.getConf();
        try {
            if (LocalHBaseCluster.isLocal(conf)) {
                MiniZooKeeperCluster zooKeeperCluster = new MiniZooKeeperCluster();
                File zkDataPath = new File(conf.get("hbase.zookeeper.property.dataDir"));
                int zkClientPort = conf.getInt("hbase.zookeeper.property.clientPort", 0);
                if (zkClientPort == 0) {
                    throw new IOException("No config value for hbase.zookeeper.property.clientPort");
                }
                zooKeeperCluster.setDefaultClientPort(zkClientPort);
                ZKUtil.loginServer(conf, "hbase.zookeeper.server.keytab.file", "hbase.zookeeper.server.kerberos.principal", null);
                int clientPort = zooKeeperCluster.startup(zkDataPath);
                if (clientPort != zkClientPort) {
                    String errorMsg = "Could not start ZK at requested port of " + zkClientPort + ".  ZK was started at port: " + clientPort + ".  Aborting as clients (e.g. shell) will not be able to find " + "this ZK quorum.";
                    System.err.println(errorMsg);
                    throw new IOException(errorMsg);
                }
                conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
                LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 1, LocalHMaster.class, HRegionServer.class);
                ((LocalHMaster)cluster.getMaster(0)).setZKCluster(zooKeeperCluster);
                cluster.startup();
                this.waitOnMasterThreads(cluster);
            } else {
                HMaster master = HMaster.constructMaster(this.masterClass, conf);
                if (master.isStopped()) {
                    LOG.info((Object)"Won't bring the Master up as a shutdown is requested");
                    return -1;
                }
                master.start();
                master.join();
                if (master.isAborted()) {
                    throw new RuntimeException("HMaster Aborted");
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to start master", t);
            return -1;
        }
        return 0;
    }

    private int stopMaster() {
        HBaseAdmin adm = null;
        try {
            Configuration conf = this.getConf();
            conf.setInt("hbase.client.retries.number", 1);
            adm = new HBaseAdmin(this.getConf());
        }
        catch (MasterNotRunningException e) {
            LOG.error((Object)"Master not running");
            return -1;
        }
        catch (ZooKeeperConnectionException e) {
            LOG.error((Object)"ZooKeeper not available");
            return -1;
        }
        try {
            adm.shutdown();
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to stop master", t);
            return -1;
        }
        return 0;
    }

    private void waitOnMasterThreads(LocalHBaseCluster cluster) throws InterruptedException {
        List<JVMClusterUtil.MasterThread> masters = cluster.getMasters();
        List<JVMClusterUtil.RegionServerThread> regionservers = cluster.getRegionServers();
        if (masters != null) {
            for (JVMClusterUtil.MasterThread t : masters) {
                t.join();
                if (!t.getMaster().isAborted()) continue;
                HMasterCommandLine.closeAllRegionServerThreads(regionservers);
                throw new RuntimeException("HMaster Aborted");
            }
        }
    }

    private static void closeAllRegionServerThreads(List<JVMClusterUtil.RegionServerThread> regionservers) {
        for (JVMClusterUtil.RegionServerThread t : regionservers) {
            t.getRegionServer().stop("HMaster Aborted; Bringing down regions servers");
        }
    }

    public static class LocalHMaster
    extends HMaster {
        private MiniZooKeeperCluster zkcluster = null;

        public LocalHMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        @Override
        public void run() {
            super.run();
            if (this.zkcluster != null) {
                try {
                    this.zkcluster.shutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        void setZKCluster(MiniZooKeeperCluster zkcluster) {
            this.zkcluster = zkcluster;
        }
    }
}

