/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class TimeToLiveHFileCleaner
extends BaseHFileCleanerDelegate {
    public static final Log LOG = LogFactory.getLog((String)TimeToLiveHFileCleaner.class.getName());
    public static final String TTL_CONF_KEY = "hbase.master.hfilecleaner.ttl";
    private static final long DEFAULT_TTL = 300000L;
    private long ttl;
    private FileSystem fs;

    @Override
    public void setConf(Configuration conf) {
        this.ttl = conf.getLong(TTL_CONF_KEY, 300000L);
        super.setConf(conf);
    }

    @Override
    public boolean isFileDeletable(Path filePath) {
        if (!this.instantiateFS()) {
            return false;
        }
        long time = 0L;
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        try {
            FileStatus fStat = this.fs.getFileStatus(filePath);
            time = fStat.getModificationTime();
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to get modification time of file " + filePath.getName() + ", not deleting it."), (Throwable)e);
            return false;
        }
        long life = currentTime - time;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HFile life:" + life + ", ttl:" + this.ttl + ", current:" + currentTime + ", from: " + time));
        }
        if (life < 0L) {
            LOG.warn((Object)("Found a log (" + filePath + ") newer than current time (" + currentTime + " < " + time + "), probably a clock skew"));
            return false;
        }
        return life > this.ttl;
    }

    private synchronized boolean instantiateFS() {
        if (this.fs == null) {
            try {
                this.fs = FileSystem.get((Configuration)this.getConf());
            }
            catch (IOException e) {
                LOG.error((Object)"Couldn't instantiate the file system, not deleting file, just incase");
                return false;
            }
        }
        return true;
    }
}

