/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;

public class MetaServerShutdownHandler
extends ServerShutdownHandler {
    private final boolean carryingRoot;
    private final boolean carryingMeta;

    public MetaServerShutdownHandler(Server server, MasterServices services, DeadServer deadServers, ServerName serverName, boolean carryingRoot, boolean carryingMeta) {
        super(server, services, deadServers, serverName, EventHandler.EventType.M_META_SERVER_SHUTDOWN, true);
        this.carryingRoot = carryingRoot;
        this.carryingMeta = carryingMeta;
    }

    @Override
    boolean isCarryingRoot() {
        return this.carryingRoot;
    }

    @Override
    boolean isCarryingMeta() {
        return this.carryingMeta;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }
}

